/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.resourceresolver.impl.mapping.BloomFilterUtils;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntries;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.PagedQueryIterator;
import org.apache.sling.resourceresolver.impl.mapping.QueryBuildHelper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanityPathHandler {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    private static final String JCR_SYSTEM_PATH = "/jcr:system";
    private static final String JCR_SYSTEM_PREFIX = "/jcr:system/";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS = "sling:redirectStatus";
    public static final String PROP_VANITY_PATH = "sling:vanityPath";
    public static final String PROP_VANITY_ORDER = "sling:vanityOrder";
    private static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private static final int VANITY_BLOOM_FILTER_MAX_ENTRIES = 10000000;
    final AtomicLong vanityCounter = new AtomicLong(0L);
    final AtomicLong vanityResourcesOnStartup = new AtomicLong(0L);
    final AtomicLong vanityPathLookups = new AtomicLong(0L);
    final AtomicLong vanityPathBloomNegatives = new AtomicLong(0L);
    final AtomicLong vanityPathBloomFalsePositives = new AtomicLong(0L);
    final AtomicLong temporaryResolveMapsMapHits = new AtomicLong();
    final AtomicLong temporaryResolveMapsMapMisses = new AtomicLong();
    private final AtomicBoolean vanityPathsProcessed = new AtomicBoolean(false);
    private final Logger log = LoggerFactory.getLogger(VanityPathHandler.class);
    private final MapConfigurationProvider factory;
    private byte[] vanityBloomFilter;
    private Map<String, List<String>> vanityTargets = Collections.emptyMap();
    private final Map<String, List<MapEntry>> resolveMapsMap;
    private final List<MapEntry> noMapEntries = Collections.emptyList();
    private static int TEMPORARY_CACHE_SIZE_LIMIT = 10000;
    private Map<String, List<MapEntry>> temporaryResolveMapsMap;
    private final ReentrantLock initializing;
    private final Consumer<String> drain;

    public VanityPathHandler(MapConfigurationProvider factory, Map<String, List<MapEntry>> resolveMapsMap, ReentrantLock initializing, Consumer<String> drain) {
        this.factory = factory;
        this.resolveMapsMap = resolveMapsMap;
        this.initializing = initializing;
        this.drain = drain;
    }

    public boolean isReady() {
        return this.vanityPathsProcessed.get();
    }

    public Map<String, List<String>> getVanityPathMappings() {
        return Collections.unmodifiableMap(this.vanityTargets);
    }

    protected void initializeVanityPaths() {
        this.initializing.lock();
        if (this.factory == null) {
            this.log.error("Can't initialize vanity paths when MapConfigurationProvider is null");
            return;
        }
        this.log.info("Initializing Vanity Paths ({}={}, {}={}, {}={}, {}={}, {}={})", new Object[]{"enable_vanitypath", this.factory.isVanityPathEnabled(), "vanitypath_cache_in_background", this.factory.isVanityPathCacheInitInBackground(), "vanitypath_maxEntries", this.factory.getMaxCachedVanityPathEntries(), "vanitypath_(allowlist/denylist)", this.factory.getVanityPathConfig(), "vanitypath_bloomfilter_maxBytes", this.factory.getVanityBloomFilterMaxBytes()});
        try {
            if (this.factory.isVanityPathEnabled()) {
                this.vanityPathsProcessed.set(false);
                this.vanityBloomFilter = this.createVanityBloomFilter();
                this.temporaryResolveMapsMap = Collections.synchronizedMap(new LRUMap(TEMPORARY_CACHE_SIZE_LIMIT));
                VanityPathInitializer vpi = new VanityPathInitializer(this.factory);
                if (this.factory.isVanityPathCacheInitInBackground()) {
                    this.log.debug("starting vanity path initialization in the background");
                    Thread vpinit = new Thread((Runnable)vpi, "VanityPathInitializer");
                    vpinit.start();
                } else {
                    vpi.run();
                }
            }
        }
        finally {
            this.initializing.unlock();
        }
    }

    boolean removeVanityPath(String path) {
        this.initializing.lock();
        try {
            boolean bl = this.doRemoveVanity(path);
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    boolean doAddVanity(Resource resource) {
        this.log.debug("doAddVanity getting {}", (Object)resource.getPath());
        boolean updateTheCache = this.isAllVanityPathEntriesCached() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries();
        return null != this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, updateTheCache, true);
    }

    private String getMapEntryRedirect(MapEntry mapEntry) {
        String[] redirect = mapEntry.getRedirect();
        if (redirect.length > 1) {
            this.log.warn("something went wrong, please restart the bundle");
            return null;
        }
        String path = redirect[0];
        if (path.endsWith("$1")) {
            path = path.substring(0, path.length() - "$1".length());
        } else if (path.endsWith(".html")) {
            path = path.substring(0, path.length() - ".html".length());
        }
        return path;
    }

    boolean doRemoveVanity(String path) {
        String actualContentPath = this.getActualContentPath(path);
        List<String> targets = this.vanityTargets.remove(actualContentPath);
        if (targets != null) {
            for (String target : targets) {
                int count = this.removeEntriesFromResolvesMap(target, actualContentPath);
                if (this.vanityCounter.longValue() < (long)count) continue;
                this.vanityCounter.addAndGet(-count);
            }
            return true;
        }
        return false;
    }

    private int removeEntriesFromResolvesMap(String target, String path) {
        List entries = Objects.requireNonNullElse(this.resolveMapsMap.get(target), Collections.emptyList());
        int count = 0;
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            MapEntry entry = (MapEntry)iterator.next();
            String redirect = this.getMapEntryRedirect(entry);
            if (!path.equals(redirect)) continue;
            iterator.remove();
            ++count;
        }
        if (entries.isEmpty()) {
            this.resolveMapsMap.remove(target);
        }
        return count;
    }

    private List<MapEntry> getMapEntryList(String vanityPath) {
        List<MapEntry> mapEntries = null;
        boolean initFinished = this.vanityPathsProcessed.get();
        boolean probablyPresent = false;
        if (initFinished) {
            long current = this.vanityPathLookups.incrementAndGet();
            if (current >= 9223372036854675807L) {
                this.vanityPathLookups.set(1L);
                this.vanityPathBloomNegatives.set(0L);
                this.vanityPathBloomFalsePositives.set(0L);
                this.log.info("Vanity Path metrics reset to 0");
            }
            probablyPresent = BloomFilterUtils.probablyContains(this.vanityBloomFilter, vanityPath);
            this.log.trace("bloom filter lookup for {} -> {}", (Object)vanityPath, (Object)probablyPresent);
            if (!probablyPresent) {
                this.vanityPathBloomNegatives.incrementAndGet();
            }
        }
        if (!initFinished || probablyPresent) {
            mapEntries = this.resolveMapsMap.get(vanityPath);
            if (mapEntries == null) {
                if (!initFinished && this.temporaryResolveMapsMap != null) {
                    mapEntries = this.getMapEntriesFromTemporaryMap(vanityPath);
                }
                if (mapEntries == null) {
                    mapEntries = this.getMapEntriesFromRepository(vanityPath, initFinished);
                }
            }
            if (mapEntries == null && probablyPresent) {
                this.vanityPathBloomFalsePositives.incrementAndGet();
            }
        }
        return mapEntries == this.noMapEntries ? null : mapEntries;
    }

    @Nullable
    private List<MapEntry> getMapEntriesFromRepository(String vanityPath, boolean initFinished) {
        Map<String, List<MapEntry>> mapEntry = this.getVanityPaths(vanityPath);
        List<MapEntry> mapEntries = mapEntry.get(vanityPath);
        if (!initFinished && this.temporaryResolveMapsMap != null) {
            this.log.trace("getMapEntryList: caching map entries for {} -> {}", (Object)vanityPath, mapEntries);
            this.temporaryResolveMapsMap.put(vanityPath, mapEntries == null ? this.noMapEntries : mapEntries);
        }
        return mapEntries;
    }

    @Nullable
    private List<MapEntry> getMapEntriesFromTemporaryMap(String vanityPath) {
        List<MapEntry> mapEntries = this.temporaryResolveMapsMap.get(vanityPath);
        if (mapEntries != null) {
            this.temporaryResolveMapsMapHits.incrementAndGet();
            this.log.trace("getMapEntryList: using temp map entries for {} -> {}", (Object)vanityPath, mapEntries);
        } else {
            this.temporaryResolveMapsMapMisses.incrementAndGet();
        }
        return mapEntries;
    }

    private byte[] createVanityBloomFilter() {
        return BloomFilterUtils.createFilter(10000000, this.factory.getVanityBloomFilterMaxBytes());
    }

    private boolean isAllVanityPathEntriesCached() {
        return this.factory.getMaxCachedVanityPathEntries() == -1L;
    }

    private Map<String, List<MapEntry>> getVanityPaths(String vanityPath) {
        Map<String, List<MapEntry>> entryMap = new HashMap<String, List<MapEntry>>();
        String queryString = String.format("SELECT [sling:vanityPath], [sling:redirect], [sling:redirectStatus] FROM [nt:base] WHERE %s AND ([sling:vanityPath]='%s' OR [sling:vanityPath]='%s') ORDER BY [sling:vanityOrder] DESC", QueryBuildHelper.excludeSystemPath(), QueryBuildHelper.escapeString(vanityPath), QueryBuildHelper.escapeString(vanityPath.substring(1)));
        try (ResourceResolver queryResolver = this.factory.getServiceResourceResolver(this.factory.getServiceUserAuthenticationInfo("mapping"));){
            long totalCount = 0L;
            long totalValid = 0L;
            this.log.debug("start vanityPath query: {}", (Object)queryString);
            Iterator i = queryResolver.findResources(queryString, "JCR-SQL2");
            this.log.debug("end vanityPath query");
            while (i.hasNext()) {
                ++totalCount;
                Resource resource = (Resource)i.next();
                boolean isValid = false;
                for (Path sPath : this.factory.getObservationPaths()) {
                    if (!sPath.matches(resource.getPath())) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) continue;
                ++totalValid;
                if (this.vanityPathsProcessed.get() && (this.factory.isMaxCachedVanityPathEntriesStartup() || this.isAllVanityPathEntriesCached() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries())) {
                    this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, true, true);
                    entryMap = this.resolveMapsMap;
                    continue;
                }
                HashMap<String, List<String>> targetPaths = new HashMap<String, List<String>>();
                this.loadVanityPath(resource, entryMap, targetPaths, true, false);
            }
            this.log.debug("read {} ({} valid) vanityPaths", (Object)totalCount, (Object)totalValid);
        }
        catch (LoginException e) {
            this.log.error("Exception while obtaining queryResolver", (Throwable)e);
        }
        return entryMap;
    }

    boolean isValidVanityPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Unexpected null path");
        }
        if (path.startsWith(JCR_SYSTEM_PREFIX)) {
            this.log.debug("isValidVanityPath: not valid {}", (Object)path);
            return false;
        }
        if (this.factory.getVanityPathConfig() != null) {
            boolean allowed = false;
            for (MapConfigurationProvider.VanityPathConfig config : this.factory.getVanityPathConfig()) {
                if (!path.startsWith(config.prefix)) continue;
                allowed = !config.isExclude;
                break;
            }
            if (!allowed) {
                this.log.debug("isValidVanityPath: not valid as not in allow list {}", (Object)path);
                return false;
            }
        }
        return true;
    }

    private Map<String, List<String>> loadVanityPaths(ResourceResolver resolver) {
        Iterator<Resource> it;
        ConcurrentHashMap<String, List<String>> targetPaths = new ConcurrentHashMap<String, List<String>>();
        String baseQueryString = "SELECT [sling:vanityPath], [sling:redirect], [sling:redirectStatus] FROM [nt:base] WHERE " + QueryBuildHelper.excludeSystemPath() + " AND [sling:vanityPath] IS NOT NULL";
        try {
            String queryStringWithSort = baseQueryString + " AND FIRST([sling:vanityPath]) >= '%s' ORDER BY FIRST([sling:vanityPath])";
            it = new PagedQueryIterator("vanity path", PROP_VANITY_PATH, resolver, queryStringWithSort, 2000);
        }
        catch (QuerySyntaxException ex) {
            this.log.debug("sort with first() not supported, falling back to base query", (Throwable)ex);
            it = this.queryUnpaged(baseQueryString, resolver);
        }
        catch (UnsupportedOperationException ex) {
            this.log.debug("query failed as unsupported, retrying without paging/sorting", (Throwable)ex);
            it = this.queryUnpaged(baseQueryString, resolver);
        }
        long count = 0L;
        long countInScope = 0L;
        StopWatch sw = StopWatch.createStarted();
        while (it.hasNext()) {
            ++count;
            Resource resource = it.next();
            String resourcePath = resource.getPath();
            if (!Stream.of(this.factory.getObservationPaths()).anyMatch(path -> path.matches(resourcePath))) continue;
            ++countInScope;
            boolean addToCache = this.isAllVanityPathEntriesCached() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries();
            this.loadVanityPath(resource, this.resolveMapsMap, targetPaths, addToCache, true);
        }
        String message = MapEntries.getTimingMessage(String.format("processed %d resources with sling:vanityPath properties (of which %d in scope)", count, countInScope), sw.getDuration(), count);
        this.log.debug(message);
        if (!this.isAllVanityPathEntriesCached()) {
            if (countInScope > this.factory.getMaxCachedVanityPathEntries()) {
                this.log.warn("Number of resources with sling:vanityPath property ({}) exceeds configured cache size ({}); handling of uncached vanity paths will be much slower. Consider increasing the cache size or decreasing the number of vanity paths.", (Object)countInScope, (Object)this.factory.getMaxCachedVanityPathEntries());
            } else if (countInScope > this.factory.getMaxCachedVanityPathEntries() / 10L * 9L) {
                this.log.info("Number of resources with sling:vanityPath property in scope ({}) within 10% of configured cache size ({})", (Object)countInScope, (Object)this.factory.getMaxCachedVanityPathEntries());
            }
        }
        this.vanityResourcesOnStartup.set(count);
        return targetPaths;
    }

    private void updateTargetPaths(Map<String, List<String>> targetPaths, String key, String entry) {
        if (entry != null) {
            List entries = targetPaths.computeIfAbsent(key, k -> new ArrayList());
            entries.add(entry);
        }
    }

    private String loadVanityPath(Resource resource, Map<String, List<MapEntry>> entryMap, Map<String, List<String>> targetPaths, boolean addToCache, boolean updateCounter) {
        if (!this.isValidVanityPath(resource.getPath())) {
            return null;
        }
        ValueMap props = resource.getValueMap();
        long vanityOrder = (Long)props.get(PROP_VANITY_ORDER, (Object)0L);
        boolean hasVanityPath = false;
        String[] pVanityPaths = (String[])props.get(PROP_VANITY_PATH, (Object)new String[0]);
        if (this.log.isTraceEnabled()) {
            this.log.trace("vanity paths on {}: {}", (Object)resource.getPath(), Arrays.asList(pVanityPaths));
        }
        for (String pVanityPath : pVanityPaths) {
            Resource redirectTarget;
            String[] result = this.getVanityPathDefinition(resource.getPath(), pVanityPath);
            if (result == null) continue;
            if (JCR_CONTENT.equals(resource.getName())) {
                redirectTarget = resource.getParent();
                if (redirectTarget == null) {
                    this.log.warn("containingResource is null for vanity path on {}, skipping.", (Object)resource.getPath());
                    continue;
                }
            } else {
                redirectTarget = resource;
            }
            hasVanityPath = true;
            String url = result[0] + result[1];
            String redirect = redirectTarget.getPath();
            String redirectName = redirectTarget.getName();
            int httpStatus = (Boolean)props.get(PROP_REDIRECT_EXTERNAL, (Object)false) != false ? (Integer)props.get(PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS, (Object)this.factory.getDefaultVanityPathRedirectStatus()) : -1;
            String checkPath = result[1];
            if (addToCache) {
                MapEntry entry2;
                MapEntry entry1;
                if (redirectName.contains(".")) {
                    String extension = redirectName.substring(redirectName.lastIndexOf(46) + 1);
                    entry1 = this.createMapEntry(url + "$", httpStatus, vanityOrder, redirect);
                    entry2 = this.createMapEntry(url + "\\." + extension, httpStatus, vanityOrder, redirect);
                } else {
                    entry1 = this.createMapEntry(url + "$", httpStatus, vanityOrder, redirect + ".html");
                    entry2 = this.createMapEntry(url + "(\\..*)", httpStatus, vanityOrder, redirect + "$1");
                }
                int count = 0;
                if (this.addEntry(entryMap, checkPath, entry1)) {
                    ++count;
                }
                if (this.addEntry(entryMap, checkPath, entry2)) {
                    ++count;
                }
                if (count <= 0) continue;
                this.updateTargetPaths(targetPaths, redirect, checkPath);
                if (updateCounter) {
                    this.vanityCounter.addAndGet(count);
                }
                BloomFilterUtils.add(this.vanityBloomFilter, checkPath);
                continue;
            }
            BloomFilterUtils.add(this.vanityBloomFilter, checkPath);
        }
        return hasVanityPath ? pVanityPaths[0] : null;
    }

    private String[] getVanityPathDefinition(String sourcePath, String vanityPath) {
        Object path;
        Object prefix;
        if (vanityPath == null) {
            this.log.trace("getVanityPathDefinition: null vanity path on {}", (Object)sourcePath);
            return null;
        }
        String info = vanityPath.trim();
        if (info.isEmpty()) {
            this.log.trace("getVanityPathDefinition: empty vanity path on {}", (Object)sourcePath);
            return null;
        }
        if (info.contains(":/")) {
            try {
                URL u = new URL(info);
                prefix = u.getProtocol() + "/" + u.getHost() + "." + u.getPort();
                path = u.getPath();
            }
            catch (MalformedURLException e) {
                this.log.warn("Ignoring malformed vanity path '{}' on {}", (Object)info, (Object)sourcePath);
                return null;
            }
        } else {
            prefix = "^[^/]+/[^/]+";
            path = !info.startsWith("/") ? "/" + info : info;
        }
        int lastSlash = ((String)path).lastIndexOf(47);
        int firstDot = ((String)path).indexOf(46, lastSlash + 1);
        if (firstDot != -1) {
            path = ((String)path).substring(0, firstDot);
            this.log.warn("Removing extension from vanity path '{}' on {}", (Object)info, (Object)sourcePath);
        }
        return new String[]{prefix, path};
    }

    @Nullable
    public Iterator<MapEntry> getCurrentMapEntryForVanityPath(String key) {
        List<MapEntry> l = this.isAllVanityPathEntriesCached() && this.vanityPathsProcessed.get() ? this.resolveMapsMap.get(key) : this.getMapEntryList(key);
        return l == null ? null : l.iterator();
    }

    private boolean addEntry(Map<String, List<MapEntry>> entryMap, String key, MapEntry entry) {
        if (entry == null) {
            this.log.trace("trying to add null entry for {}", (Object)key);
            return false;
        }
        List<MapEntry> entries = entryMap.get(key);
        ArrayList<MapEntry> entriesCopy = new ArrayList<MapEntry>(entries != null ? entries : List.of());
        entriesCopy.add(entry);
        Collections.sort(entriesCopy);
        entryMap.put(key, entriesCopy);
        int size = entriesCopy.size();
        if (size == 10) {
            this.log.debug("10 MapEntries for {} - check your configuration", (Object)key);
        } else if (size == 100) {
            this.log.info("100 MapEntries for {} - check your configuration", (Object)key);
        }
        return true;
    }

    private String getActualContentPath(String path) {
        if (path.endsWith(JCR_CONTENT_SUFFIX)) {
            return ResourceUtil.getParent((String)path);
        }
        return path;
    }

    private MapEntry createMapEntry(String urlPattern, int httpStatus, long order, String ... redirects) {
        try {
            return new MapEntry(urlPattern, httpStatus, false, order, redirects);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry for {} due to exception", (Object)urlPattern, (Object)iae);
            return null;
        }
    }

    private Iterator<Resource> queryUnpaged(String query, ResourceResolver resolver) {
        this.log.debug("start vanity path query: {}", (Object)query);
        StopWatch sw = StopWatch.createStarted();
        Iterator it = resolver.findResources(query, "JCR-SQL2");
        this.log.debug("end vanity path query; elapsed {} ({}ms)", (Object)sw.getDuration(), (Object)sw.getDuration().toMillis());
        return it;
    }

    private class VanityPathInitializer
    implements Runnable {
        private final MapConfigurationProvider factory;

        public VanityPathInitializer(MapConfigurationProvider factory) {
            this.factory = factory;
        }

        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (Exception ex) {
                VanityPathHandler.this.log.error("vanity path initializer thread terminated with an exception", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.factory.getServiceUserAuthenticationInfo("mapping"));){
                StopWatch sw = StopWatch.createStarted();
                VanityPathHandler.this.log.debug("vanity path initialization - start");
                VanityPathHandler.this.vanityTargets = VanityPathHandler.this.loadVanityPaths(resolver);
                VanityPathHandler.this.drain.accept("draining vanity path event queue (during cache initialization)");
                VanityPathHandler.this.vanityPathsProcessed.set(true);
                VanityPathHandler.this.drain.accept("draining vanity path event queue (after cache initialization)");
                String message = MapEntries.getTimingMessage("vanity path initialization - completed", sw.getDuration(), VanityPathHandler.this.vanityResourcesOnStartup.get());
                VanityPathHandler.this.log.info(message);
            }
            catch (LoginException ex) {
                try {
                    VanityPathHandler.this.log.error("vanity path init failed", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    VanityPathHandler.this.log.debug("dropping temporary resolver map - {}/{} entries, {} hits, {} misses", new Object[]{VanityPathHandler.this.temporaryResolveMapsMap.size(), TEMPORARY_CACHE_SIZE_LIMIT, VanityPathHandler.this.temporaryResolveMapsMapHits.get(), VanityPathHandler.this.temporaryResolveMapsMapMisses.get()});
                    VanityPathHandler.this.temporaryResolveMapsMap = null;
                    throw throwable;
                }
                VanityPathHandler.this.log.debug("dropping temporary resolver map - {}/{} entries, {} hits, {} misses", new Object[]{VanityPathHandler.this.temporaryResolveMapsMap.size(), TEMPORARY_CACHE_SIZE_LIMIT, VanityPathHandler.this.temporaryResolveMapsMapHits.get(), VanityPathHandler.this.temporaryResolveMapsMapMisses.get()});
                VanityPathHandler.this.temporaryResolveMapsMap = null;
            }
            VanityPathHandler.this.log.debug("dropping temporary resolver map - {}/{} entries, {} hits, {} misses", new Object[]{VanityPathHandler.this.temporaryResolveMapsMap.size(), TEMPORARY_CACHE_SIZE_LIMIT, VanityPathHandler.this.temporaryResolveMapsMapHits.get(), VanityPathHandler.this.temporaryResolveMapsMapMisses.get()});
            VanityPathHandler.this.temporaryResolveMapsMap = null;
        }
    }
}

