/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.samples.pathbasedrtp;

import java.util.Dictionary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.jcr.resource.JcrResourceTypeProvider;
import org.apache.sling.samples.pathbasedrtp.Mapping;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceTypeProvider
implements JcrResourceTypeProvider {
    private static final String PROP_PATH_MAPPING = "path.mapping";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Mapping[] mappings;

    public String getResourceTypeForNode(Node node) throws RepositoryException {
        String result = null;
        if (this.mappings != null) {
            String nt = node.getPrimaryNodeType().getName();
            String path = node.getPath();
            for (Mapping m : this.mappings) {
                result = m.getResourceType(path, nt);
                if (result == null) continue;
                this.log.debug("Default resource type {} used for Node {}", (Object)result, (Object)path);
                break;
            }
        }
        if (result == null) {
            this.log.debug("No Mapping applies to node {}, no resource type provided", (Object)node.getPath());
        }
        return result;
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        String[] mappingList = (String[])properties.get(PROP_PATH_MAPPING);
        if (mappingList == null || mappingList.length == 0) {
            this.mappings = null;
        } else {
            this.mappings = new Mapping[mappingList.length];
            for (int i = 0; i < mappingList.length; ++i) {
                this.mappings[i] = new Mapping(mappingList[i]);
                this.log.debug("Added {}", (Object)this.mappings[i]);
            }
        }
    }
}

