/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.samples.pathbasedrtp;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Mapping {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    String path;
    final String fixedNodeType;
    final Pattern nodeTypeExpr;
    int resourceTypeIndex;
    public static final String DEFAULT_NODE_TYPE = "nt:unstructured";

    Mapping(String definition) {
        String[] parts = definition.trim().split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Illegal definition'" + definition + "'");
        }
        this.path = parts[0];
        try {
            this.resourceTypeIndex = Integer.parseInt(parts[1]);
        }
        catch (Exception e) {
            this.log.warn("Invalid path index in Mapping {}", (Object)definition);
        }
        if (parts.length > 2) {
            StringBuilder sb = new StringBuilder();
            for (int i = 2; i < parts.length; ++i) {
                sb.append(parts[i]);
                if (i >= parts.length - 1) continue;
                sb.append(":");
            }
            String expr = sb.toString();
            if (expr.startsWith("(") && expr.endsWith(")")) {
                this.fixedNodeType = null;
                expr = expr.substring(1);
                expr = expr.substring(0, expr.length() - 1);
                this.nodeTypeExpr = Pattern.compile(expr);
            } else {
                this.fixedNodeType = expr;
                this.nodeTypeExpr = null;
            }
        } else {
            this.fixedNodeType = DEFAULT_NODE_TYPE;
            this.nodeTypeExpr = null;
        }
        this.log.debug(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Mapping: path=");
        sb.append(this.path);
        sb.append(", resource type index=");
        sb.append(this.resourceTypeIndex);
        if (this.fixedNodeType != null) {
            sb.append(", node type=");
            sb.append(this.fixedNodeType);
        } else {
            sb.append(", node type regexp=");
            sb.append(this.nodeTypeExpr);
        }
        return sb.toString();
    }

    String getResourceType(String nodePath, String nodeType) {
        String[] paths;
        String result = null;
        if (this.path != null && nodePath.startsWith(this.path) && this.nodeTypeMatches(nodeType) && (paths = nodePath.split("/")).length >= this.resourceTypeIndex + 1) {
            result = paths[this.resourceTypeIndex];
        }
        return result;
    }

    private boolean nodeTypeMatches(String nodeType) {
        if (this.fixedNodeType != null) {
            return this.fixedNodeType.equals(nodeType);
        }
        if (this.nodeTypeExpr == null) {
            throw new IllegalStateException("Neither fixedNodeType nor nodeTypeExpr supplied in " + this);
        }
        return this.nodeTypeExpr.matcher(nodeType).matches();
    }
}

