/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.errors;

import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.EnterpriseSecurityRuntimeException;

public class IntrusionException
extends EnterpriseSecurityRuntimeException {
    private static final long serialVersionUID = 1L;
    protected final transient Logger logger = ESAPI.getLogger("IntrusionException");
    protected String logMessage = null;

    public IntrusionException(String userMessage, String logMessage) {
        super(userMessage);
        this.logMessage = logMessage;
        this.logger.error(Logger.SECURITY_FAILURE, "INTRUSION - " + logMessage);
    }

    public IntrusionException(String userMessage, String logMessage, Throwable cause) {
        super(userMessage, cause);
        this.logMessage = logMessage;
        this.logger.error(Logger.SECURITY_FAILURE, "INTRUSION - " + logMessage, cause);
    }

    @Override
    public String getUserMessage() {
        return this.getMessage();
    }

    @Override
    public String getLogMessage() {
        return this.logMessage;
    }
}

