/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.validation;

import java.text.DateFormat;
import java.util.Date;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.validation.BaseValidationRule;

public class DateValidationRule
extends BaseValidationRule {
    private DateFormat format = DateFormat.getDateInstance();

    public DateValidationRule(String typeName, Encoder encoder, DateFormat newFormat) {
        super(typeName, encoder);
        this.setDateFormat(newFormat);
    }

    public final void setDateFormat(DateFormat newFormat) {
        if (newFormat == null) {
            throw new IllegalArgumentException("DateValidationRule.setDateFormat requires a non-null DateFormat");
        }
        this.format = newFormat;
        this.format.setLenient(ESAPI.securityConfiguration().getLenientDatesAccepted());
    }

    @Override
    public Date getValid(String context, String input) throws ValidationException {
        return this.safelyParse(context, input);
    }

    @Override
    public Date sanitize(String context, String input) {
        Date date = new Date(0L);
        try {
            date = this.safelyParse(context, input);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return date;
    }

    private Date safelyParse(String context, String input) throws ValidationException {
        if (StringUtilities.isEmpty(input)) {
            if (this.allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input date required", "Input date required: context=" + context + ", input=" + input, context);
        }
        String canonical = this.encoder.canonicalize(input);
        try {
            return this.format.parse(canonical);
        }
        catch (Exception e) {
            throw new ValidationException(context + ": Invalid date must follow the " + this.format.getNumberFormat() + " format", "Invalid date: context=" + context + ", format=" + this.format + ", input=" + input, e, context);
        }
    }
}

