/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder.extensions;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sling.sitemap.builder.extensions.GoogleVideoExtension;
import org.apache.sling.sitemap.spi.builder.AbstractExtension;
import org.apache.sling.sitemap.spi.builder.SitemapExtensionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"extension.interface=org.apache.sling.sitemap.builder.extensions.GoogleVideoExtension", "extension.prefix=video", "extension.namespace=http://www.google.com/schemas/sitemap-video/1.1", "extension.localName=video"})
public class GoogleVideoExtensionProvider
implements SitemapExtensionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleVideoExtensionProvider.class);

    @Override
    @NotNull
    public AbstractExtension newInstance() {
        return new ExtensionImpl();
    }

    private static class ExtensionImpl
    extends AbstractExtension
    implements GoogleVideoExtension {
        private String thumbnailLocation;
        private String title;
        private String description;
        private String contentLocation;
        private String playerLocation;
        private String duration;
        private TemporalAccessor expirationDate;
        private String rating;
        private String viewCount;
        private TemporalAccessor publicationDate;
        private List<String> tags;
        private String category;
        private String familyFriendly;
        private String accessRestrictions;
        private String accessRestrictionsRel;
        private String platformRestrictions;
        private String platformRestrictionsRel;
        private Collection<PriceImpl> prices;
        private String requiresSubscription;
        private String uploader;
        private String uploaderInfo;
        private String live;

        private ExtensionImpl() {
        }

        private static String booleanToString(Boolean bool) {
            if (bool != null) {
                return bool != false ? "yes" : "no";
            }
            return null;
        }

        private static String required(String object, String message) throws XMLStreamException {
            if (object == null) {
                throw new XMLStreamException(message);
            }
            return object;
        }

        private static void write(XMLStreamWriter writer, String value, String tag) throws XMLStreamException {
            writer.writeStartElement(tag);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }

        private static void write(XMLStreamWriter writer, TemporalAccessor date, String tag) throws XMLStreamException {
            try {
                if (date instanceof LocalDate) {
                    ExtensionImpl.write(writer, DateTimeFormatter.ISO_LOCAL_DATE.format(date), tag);
                } else {
                    ExtensionImpl.write(writer, DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(date), tag);
                }
            }
            catch (RuntimeException ex) {
                throw new XMLStreamException("failed to write " + tag, ex);
            }
        }

        private static void writeCond(XMLStreamWriter writer, String value, String tag) throws XMLStreamException {
            if (value != null) {
                ExtensionImpl.write(writer, value, tag);
            }
        }

        private static void writeCond(XMLStreamWriter writer, TemporalAccessor value, String tag) throws XMLStreamException {
            if (value != null) {
                ExtensionImpl.write(writer, value, tag);
            }
        }

        private static void writeReq(XMLStreamWriter writer, String value, String tag, String msg) throws XMLStreamException {
            ExtensionImpl.write(writer, ExtensionImpl.required(value, msg), tag);
        }

        @Override
        @NotNull
        public GoogleVideoExtension setThumbnail(@NotNull String thumbnailLocation) {
            this.thumbnailLocation = thumbnailLocation;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setTitle(@NotNull String title) {
            this.title = title;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setDescription(@NotNull String description) {
            this.description = description;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setUrl(@Nullable String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setPlayerUrl(@Nullable String playerLocation) {
            this.playerLocation = playerLocation;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setDuration(@Nullable Integer duration) {
            if (duration != null) {
                if (duration < 0 || duration > 28800) {
                    LOG.warn("Adjusting duration as it is out of bounds (0, 28800): {}", (Object)duration);
                    duration = Math.max(0, Math.min(duration, 28800));
                }
                this.duration = String.valueOf(duration);
            } else {
                this.duration = null;
            }
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setExpirationDate(@Nullable LocalDate date) {
            this.expirationDate = date;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setExpirationDate(@Nullable OffsetDateTime date) {
            this.expirationDate = date;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setRating(@Nullable Float rating) {
            if (rating != null) {
                if (rating.floatValue() < 0.0f || rating.floatValue() > 5.0f) {
                    LOG.warn("Adjusting rating as it is out of bounds (0,5): {}", (Object)rating);
                    rating = Float.valueOf(Math.max(0.0f, Math.min(rating.floatValue(), 5.0f)));
                }
                this.rating = String.valueOf(rating);
            } else {
                this.rating = null;
            }
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setViewCount(@Nullable Integer viewCount) {
            if (viewCount != null) {
                if (viewCount < 0) {
                    LOG.warn("Adjusting negative view count: {}", (Object)viewCount);
                    viewCount = 0;
                }
                this.viewCount = String.valueOf(viewCount);
            } else {
                this.viewCount = null;
            }
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setPublicationDate(@Nullable LocalDate date) {
            this.publicationDate = date;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setPublicationDate(@Nullable OffsetDateTime date) {
            this.publicationDate = date;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setTags(@Nullable Collection<String> tags) {
            this.tags = tags != null ? new ArrayList<String>(tags) : null;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setCategory(@Nullable String category) {
            this.category = category;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setFamilyFriendly(@Nullable Boolean familyFriendly) {
            this.familyFriendly = ExtensionImpl.booleanToString(familyFriendly);
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setAccessRestriction(@Nullable GoogleVideoExtension.Access restriction, @Nullable Collection<String> countryCodes) {
            String accessRestrictionsCorrected;
            String string = accessRestrictionsCorrected = countryCodes != null ? countryCodes.stream().map(countryCode -> countryCode.toUpperCase(Locale.ROOT)).filter(countryCode -> countryCode.length() == 2).collect(Collectors.joining(" ")) : null;
            if (restriction != null && accessRestrictionsCorrected != null && accessRestrictionsCorrected.length() > 0) {
                this.accessRestrictions = accessRestrictionsCorrected;
                this.accessRestrictionsRel = restriction.getValue();
            } else {
                this.accessRestrictions = null;
                this.accessRestrictionsRel = null;
            }
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setPlatformRestriction(@Nullable GoogleVideoExtension.Access restriction, @Nullable Collection<GoogleVideoExtension.Platform> platforms) {
            if (restriction != null && platforms != null) {
                this.platformRestrictions = platforms.stream().map(GoogleVideoExtension.Platform::getValue).collect(Collectors.joining(" "));
                this.platformRestrictionsRel = restriction.getValue();
            } else {
                this.platformRestrictions = null;
                this.platformRestrictionsRel = null;
            }
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension addPrice(float price, @NotNull String currency, @Nullable GoogleVideoExtension.PriceType type, @Nullable GoogleVideoExtension.Resolution resolution) {
            if (this.prices == null) {
                this.prices = new ArrayList<PriceImpl>();
            }
            PriceImpl newPrice = new PriceImpl();
            newPrice.price = String.valueOf(price);
            newPrice.currency = currency;
            newPrice.type = type != null ? type.getValue() : null;
            newPrice.resolution = resolution != null ? resolution.getValue() : null;
            this.prices.add(newPrice);
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setRequiresSubscription(@Nullable Boolean requiresSubscription) {
            this.requiresSubscription = ExtensionImpl.booleanToString(requiresSubscription);
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setUploader(@Nullable String uploader) {
            this.uploader = uploader;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setUploaderUrl(@Nullable String uploaderInfo) {
            this.uploaderInfo = uploaderInfo;
            return this;
        }

        @Override
        @NotNull
        public GoogleVideoExtension setLive(@Nullable Boolean live) {
            this.live = ExtensionImpl.booleanToString(live);
            return this;
        }

        @Override
        public void writeTo(@NotNull XMLStreamWriter writer) throws XMLStreamException {
            ExtensionImpl.writeReq(writer, this.thumbnailLocation, "thumbnail_loc", "thumbnail location missing");
            ExtensionImpl.writeReq(writer, this.title, "title", "title missing");
            ExtensionImpl.writeReq(writer, this.description, "description", "description missing");
            if (this.contentLocation == null && this.playerLocation == null) {
                throw new XMLStreamException("either content location or player location is required");
            }
            if (this.contentLocation != null) {
                ExtensionImpl.write(writer, this.contentLocation, "content_loc");
            } else {
                ExtensionImpl.write(writer, this.playerLocation, "player_loc");
            }
            ExtensionImpl.writeCond(writer, this.duration, "duration");
            ExtensionImpl.writeCond(writer, this.expirationDate, "expiration_date");
            ExtensionImpl.writeCond(writer, this.rating, "rating");
            ExtensionImpl.writeCond(writer, this.viewCount, "view_count");
            ExtensionImpl.writeCond(writer, this.publicationDate, "publication_date");
            this.writeTags(writer);
            ExtensionImpl.writeCond(writer, this.category, "category");
            ExtensionImpl.writeCond(writer, this.familyFriendly, "family_friendly");
            ExtensionImpl.writeRestriction(writer, this.accessRestrictions, this.accessRestrictionsRel, "restriction");
            this.writePrices(writer);
            ExtensionImpl.writeCond(writer, this.requiresSubscription, "requires_subscription");
            this.writeUploader(writer);
            ExtensionImpl.writeRestriction(writer, this.platformRestrictions, this.platformRestrictionsRel, "platform");
            ExtensionImpl.writeCond(writer, this.live, "live");
        }

        private void writeTags(XMLStreamWriter writer) throws XMLStreamException {
            if (this.tags != null) {
                if (this.tags.size() > 32) {
                    LOG.warn("Truncating tags as more then 32 were given: {}", (Object)this.tags.size());
                }
                for (String tag : this.tags.subList(0, Math.min(this.tags.size(), 32))) {
                    writer.writeStartElement("tag");
                    writer.writeCharacters(tag);
                    writer.writeEndElement();
                }
            }
        }

        private void writePrices(XMLStreamWriter writer) throws XMLStreamException {
            if (this.prices != null) {
                for (PriceImpl price : this.prices) {
                    writer.writeStartElement("price");
                    writer.writeAttribute("currency", price.currency);
                    if (price.type != null) {
                        writer.writeAttribute("type", price.type);
                    }
                    if (price.resolution != null) {
                        writer.writeAttribute("resolution", price.resolution);
                    }
                    writer.writeCharacters(price.price);
                    writer.writeEndElement();
                }
            }
        }

        private void writeUploader(XMLStreamWriter writer) throws XMLStreamException {
            if (this.uploader != null) {
                writer.writeStartElement("uploader");
                if (this.uploaderInfo != null) {
                    writer.writeAttribute("info", this.uploaderInfo);
                }
                writer.writeCharacters(this.uploader);
                writer.writeEndElement();
            }
        }

        private static void writeRestriction(XMLStreamWriter writer, String value, String rel, String tag) throws XMLStreamException {
            if (value != null) {
                writer.writeStartElement(tag);
                writer.writeAttribute("relationship", rel);
                writer.writeCharacters(value);
                writer.writeEndElement();
            }
        }
    }

    private static class PriceImpl {
        private String currency;
        private String type;
        private String resolution;
        private String price;

        private PriceImpl() {
        }
    }
}

