/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.jackrabbit.core.data.db.TempFileInputStream;

public class ResettableTempFileInputStream
extends TempFileInputStream {
    private final FileChannel fileChannel;
    private long mark = 0L;

    public ResettableTempFileInputStream(File file) throws FileNotFoundException {
        this(new FileInputStream(file), file);
    }

    private ResettableTempFileInputStream(FileInputStream in, File file) {
        super(in, file);
        this.fileChannel = in.getChannel();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.fileChannel.position();
        }
        catch (IOException ex) {
            this.mark = -1L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("Mark failed");
        }
        this.fileChannel.position(this.mark);
    }
}

