/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivilegeManagerDelegator
implements PrivilegeManager {
    private final PrivilegeManager pm;
    private final SessionDelegate delegate;

    public PrivilegeManagerDelegator(SessionDelegate delegate, PrivilegeManager pm) {
        this.pm = pm;
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Privilege[] getRegisteredPrivileges() throws RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege[]>("getRegisteredPrivileges"){

            @Override
            @NotNull
            public Privilege[] perform() throws RepositoryException {
                return PrivilegeManagerDelegator.this.pm.getRegisteredPrivileges();
            }
        });
    }

    @Override
    @NotNull
    public Privilege getPrivilege(final @NotNull String privilegeName) throws AccessControlException, RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege>("getPrivilege"){

            @Override
            @NotNull
            public Privilege perform() throws RepositoryException {
                return PrivilegeManagerDelegator.this.pm.getPrivilege(privilegeName);
            }
        });
    }

    @Override
    @NotNull
    public Privilege registerPrivilege(final @NotNull String privilegeName, final boolean isAbstract, final @Nullable String[] declaredAggregateNames) throws AccessDeniedException, NamespaceException, RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege>("registerPrivilege", true){

            @Override
            @NotNull
            public Privilege perform() throws RepositoryException {
                return PrivilegeManagerDelegator.this.pm.registerPrivilege(privilegeName, isAbstract, declaredAggregateNames);
            }
        });
    }
}

