/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.security.authorization.permission.ReadStatus;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

final class RepoPolicyTreePermission
implements TreePermission {
    private RepositoryPermission repoPermission;
    private ReadStatus readStatus;

    RepoPolicyTreePermission(@NotNull RepositoryPermission repoPermission) {
        this.repoPermission = repoPermission;
    }

    @NotNull
    TreePermission getChildPermission() {
        return this;
    }

    @Override
    @NotNull
    public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
        return this.getChildPermission();
    }

    @Override
    public boolean canRead() {
        return this.getReadStatus().allowsThis();
    }

    @Override
    public boolean canRead(@NotNull PropertyState property) {
        return this.getReadStatus().allowsThis();
    }

    @Override
    public boolean canReadAll() {
        return this.getReadStatus().allowsAll();
    }

    @Override
    public boolean canReadProperties() {
        return this.getReadStatus().allowsProperties();
    }

    @Override
    public boolean isGranted(long permissions) {
        return this.repoPermission.isGranted(permissions);
    }

    @Override
    public boolean isGranted(long permissions, @NotNull PropertyState property) {
        return this.repoPermission.isGranted(permissions);
    }

    @NotNull
    private ReadStatus getReadStatus() {
        if (this.readStatus == null) {
            boolean canRead = this.repoPermission.isGranted(128L);
            this.readStatus = canRead ? ReadStatus.ALLOW_ALL : ReadStatus.DENY_ALL;
        }
        return this.readStatus;
    }
}

