/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.nodetype.NodeTypeIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProviderAware;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.base.Strings;

class UserInitializer
implements WorkspaceInitializer,
UserConstants,
QueryIndexProviderAware {
    private static final Logger log = LoggerFactory.getLogger(UserInitializer.class);
    private final SecurityProvider securityProvider;
    private QueryIndexProvider queryIndexProvider = new CompositeQueryIndexProvider(new PropertyIndexProvider(), new NodeTypeIndexProvider());

    UserInitializer(@NotNull SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public void initialize(NodeBuilder builder, String workspaceName) {
        NodeState base = ModifiedNodeState.squeeze(builder.getNodeState());
        MemoryNodeStore store = new MemoryNodeStore(base);
        Root root = RootFactory.createSystemRoot(store, EmptyHook.INSTANCE, workspaceName, this.securityProvider, this.queryIndexProvider);
        UserConfiguration userConfiguration = this.securityProvider.getConfiguration(UserConfiguration.class);
        UserManager userManager = userConfiguration.getUserManager(root, NamePathMapper.DEFAULT);
        String errorMsg = "Failed to initialize user content.";
        try {
            String anonymousId;
            ConfigurationParameters params;
            String adminId;
            Tree rootTree = root.getTree("/");
            Preconditions.checkState(rootTree.exists());
            Tree index = TreeUtil.getOrAddChild(rootTree, "oak:index", "nt:unstructured");
            if (!index.hasChild("authorizableId")) {
                Tree authorizableId = IndexUtils.createIndexDefinition(index, "authorizableId", true, new String[]{"rep:authorizableId"}, "rep:Authorizable");
                authorizableId.setProperty("info", "Oak index used by the user management to enforce uniqueness of rep:authorizableId property values.");
            }
            if (!index.hasChild("principalName")) {
                Tree principalName = IndexUtils.createIndexDefinition(index, "principalName", true, new String[]{"rep:principalName"}, "rep:Authorizable");
                principalName.setProperty("info", "Oak index used by the user management to enforce uniqueness of rep:principalName property values, and to quickly search a principal by name if it was constructed manually.");
            }
            if (!index.hasChild("repMembers")) {
                Tree members = IndexUtils.createIndexDefinition(index, "repMembers", false, new String[]{"rep:members"}, "rep:MemberReferences");
                members.setProperty("info", "Oak index used by the user management to lookup group membership.");
            }
            if (userManager.getAuthorizable(adminId = (params = userConfiguration.getParameters()).getConfigValue("adminId", "admin")) == null) {
                boolean omitPw = params.getConfigValue("omitAdminPw", false);
                userManager.createUser(adminId, omitPw ? null : adminId);
            }
            if ((anonymousId = Strings.emptyToNull(params.getConfigValue("anonymousId", "anonymous", String.class))) != null && userManager.getAuthorizable(anonymousId) == null) {
                userManager.createUser(anonymousId, null);
            }
            if (root.hasPendingChanges()) {
                root.commit();
            }
        }
        catch (RepositoryException | CommitFailedException e) {
            log.error(errorMsg, e);
            throw new RuntimeException(e);
        }
        NodeState target = store.getRoot();
        target.compareAgainstBaseState(base, new ApplyDiff(builder));
    }

    @Override
    public void setQueryIndexProvider(QueryIndexProvider provider) {
        this.queryIndexProvider = provider;
    }
}

