/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ConflictHandlers {
    private ConflictHandlers() {
    }

    public static ThreeWayConflictHandler wrap(PartialConflictHandler handler) {
        return new ThreeWayConflictHandlerWrapper(handler);
    }

    private static ThreeWayConflictHandler.Resolution wrap(PartialConflictHandler.Resolution r) {
        if (r == null) {
            return ThreeWayConflictHandler.Resolution.IGNORED;
        }
        switch (r) {
            case OURS: {
                return ThreeWayConflictHandler.Resolution.OURS;
            }
            case THEIRS: {
                return ThreeWayConflictHandler.Resolution.THEIRS;
            }
            case MERGED: {
                return ThreeWayConflictHandler.Resolution.MERGED;
            }
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    private static class ThreeWayConflictHandlerWrapper
    implements ThreeWayConflictHandler {
        private final PartialConflictHandler handler;

        public ThreeWayConflictHandlerWrapper(PartialConflictHandler handler) {
            this.handler = handler;
        }

        @Override
        public ThreeWayConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
            return ConflictHandlers.wrap(this.handler.addExistingProperty(parent, ours, theirs));
        }

        @Override
        public ThreeWayConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours, PropertyState base) {
            return ConflictHandlers.wrap(this.handler.changeDeletedProperty(parent, ours));
        }

        @Override
        public ThreeWayConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs, PropertyState base) {
            return ConflictHandlers.wrap(this.handler.changeChangedProperty(parent, ours, theirs));
        }

        @Override
        public ThreeWayConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState base) {
            return ConflictHandlers.wrap(this.handler.deleteDeletedProperty(parent, base));
        }

        @Override
        public ThreeWayConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs, PropertyState base) {
            return ConflictHandlers.wrap(this.handler.deleteChangedProperty(parent, theirs));
        }

        @Override
        public ThreeWayConflictHandler.Resolution addExistingNode(NodeBuilder parent, String name, NodeState ours, NodeState theirs) {
            return ConflictHandlers.wrap(this.handler.addExistingNode(parent, name, ours, theirs));
        }

        @Override
        public ThreeWayConflictHandler.Resolution changeDeletedNode(NodeBuilder parent, String name, NodeState ours, NodeState base) {
            return ConflictHandlers.wrap(this.handler.changeDeletedNode(parent, name, ours));
        }

        @Override
        public ThreeWayConflictHandler.Resolution deleteChangedNode(NodeBuilder parent, String name, NodeState theirs, NodeState base) {
            return ConflictHandlers.wrap(this.handler.deleteChangedNode(parent, name, theirs));
        }

        @Override
        public ThreeWayConflictHandler.Resolution deleteDeletedNode(NodeBuilder parent, String name, NodeState base) {
            return ConflictHandlers.wrap(this.handler.deleteDeletedNode(parent, name));
        }
    }
}

