/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query.fulltext;

import java.text.ParseException;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextTerm;

public class FullTextParser {
    private static final boolean JACKRABBIT_2_SINGLE_QUOTED_PHRASE = true;
    private String propertyName;
    private String text;
    private int parseIndex;

    public static FullTextExpression parse(String propertyName, String text) throws ParseException {
        FullTextParser p = new FullTextParser();
        p.propertyName = propertyName;
        p.text = text;
        FullTextExpression e = p.parseOr();
        return e;
    }

    FullTextExpression parseOr() throws ParseException {
        ArrayList<FullTextExpression> list = new ArrayList<FullTextExpression>();
        list.add(this.parseAnd());
        while (this.parseIndex < this.text.length() && this.text.substring(this.parseIndex).startsWith("OR ")) {
            this.parseIndex += 3;
            list.add(this.parseAnd());
        }
        FullTextOr or = new FullTextOr(list);
        return or.simplify();
    }

    FullTextExpression parseAnd() throws ParseException {
        ArrayList<FullTextExpression> list = new ArrayList<FullTextExpression>();
        list.add(this.parseTerm());
        while (this.parseIndex < this.text.length() && !this.text.substring(this.parseIndex).startsWith("OR ")) {
            list.add(this.parseTerm());
        }
        FullTextAnd and = new FullTextAnd(list);
        return and.simplify();
    }

    FullTextExpression parseTerm() throws ParseException {
        String boost;
        boolean escaped;
        char c;
        StringBuilder buff;
        boolean not;
        block31: {
            if (this.parseIndex >= this.text.length()) {
                throw this.getSyntaxError("term");
            }
            not = false;
            buff = new StringBuilder();
            c = this.text.charAt(this.parseIndex);
            if (c == '-' && this.parseIndex < this.text.length() - 1 && this.text.charAt(this.parseIndex + 1) != ' ') {
                c = this.text.charAt(++this.parseIndex);
                not = true;
            }
            escaped = false;
            boost = null;
            if (c == '\"') {
                ++this.parseIndex;
                while (true) {
                    if (this.parseIndex >= this.text.length()) {
                        throw this.getSyntaxError("double quote");
                    }
                    if ((c = this.text.charAt(this.parseIndex++)) == '\\') {
                        escaped = true;
                        if (this.parseIndex >= this.text.length()) {
                            throw this.getSyntaxError("escaped char");
                        }
                        c = this.text.charAt(this.parseIndex++);
                        buff.append(c);
                        continue;
                    }
                    if (c == '\"') {
                        if (this.parseIndex < this.text.length()) {
                            if (this.text.charAt(this.parseIndex) == '^') {
                                boost = "";
                            } else if (this.text.charAt(this.parseIndex) != ' ') {
                                throw this.getSyntaxError("space");
                            }
                        }
                        ++this.parseIndex;
                        break block31;
                    }
                    buff.append(c);
                }
            }
            if (c == '\'') {
                ++this.parseIndex;
                while (true) {
                    if (this.parseIndex >= this.text.length()) {
                        throw this.getSyntaxError("single quote");
                    }
                    if ((c = this.text.charAt(this.parseIndex++)) == '\\') {
                        escaped = true;
                        if (this.parseIndex >= this.text.length()) {
                            throw this.getSyntaxError("escaped char");
                        }
                        c = this.text.charAt(this.parseIndex++);
                        buff.append(c);
                        continue;
                    }
                    if (c == '\'') {
                        if (this.parseIndex < this.text.length()) {
                            if (this.text.charAt(this.parseIndex) == '^') {
                                boost = "";
                            } else if (this.text.charAt(this.parseIndex) != ' ') {
                                throw this.getSyntaxError("space");
                            }
                        }
                        ++this.parseIndex;
                        break block31;
                    }
                    buff.append(c);
                }
            }
            do {
                if ((c = this.text.charAt(this.parseIndex++)) == '\\') {
                    escaped = true;
                    if (this.parseIndex >= this.text.length()) {
                        throw this.getSyntaxError("escaped char");
                    }
                    c = this.text.charAt(this.parseIndex++);
                    buff.append(c);
                    continue;
                }
                if (c == '^') {
                    boost = "";
                    break;
                }
                if (c <= ' ') {
                    while (this.parseIndex < this.text.length() && (c = this.text.charAt(this.parseIndex)) <= ' ') {
                        ++this.parseIndex;
                    }
                    break;
                }
                buff.append(c);
            } while (this.parseIndex < this.text.length());
        }
        if (boost != null) {
            StringBuilder b = new StringBuilder();
            while (this.parseIndex < this.text.length() && ((c = this.text.charAt(this.parseIndex++)) >= '0' && c <= '9' || c == '.')) {
                b.append(c);
            }
            boost = b.toString();
        }
        if (buff.length() == 0) {
            throw this.getSyntaxError("term");
        }
        String text = buff.toString();
        FullTextTerm term = new FullTextTerm(this.propertyName, text, not, escaped, boost);
        return term.simplify();
    }

    private ParseException getSyntaxError(String expected) {
        int index = Math.max(0, Math.min(this.parseIndex, this.text.length() - 1));
        String query = this.text.substring(0, index) + "(*)" + this.text.substring(index).trim();
        if (expected != null) {
            query = query + "; expected: " + expected;
        }
        return new ParseException("FullText expression: " + query, index);
    }
}

