/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrivilegeDefinitionReader
implements PrivilegeConstants {
    private final Tree privilegesTree;

    PrivilegeDefinitionReader(@NotNull Root root) {
        this.privilegesTree = root.getTree("/jcr:system/rep:privileges");
    }

    @NotNull
    Map<String, PrivilegeDefinition> readDefinitions() {
        HashMap<String, PrivilegeDefinition> definitions = new HashMap<String, PrivilegeDefinition>();
        for (Tree child : this.privilegesTree.getChildren()) {
            if (!PrivilegeDefinitionReader.isPrivilegeDefinition(child)) continue;
            PrivilegeDefinition def = PrivilegeUtil.readDefinition(child);
            definitions.put(def.getName(), def);
        }
        return definitions;
    }

    @Nullable
    PrivilegeDefinition readDefinition(@NotNull String privilegeName) {
        if (!this.privilegesTree.exists() || !this.privilegesTree.hasChild(privilegeName)) {
            return null;
        }
        Tree definitionTree = this.privilegesTree.getChild(privilegeName);
        return PrivilegeDefinitionReader.isPrivilegeDefinition(definitionTree) ? PrivilegeUtil.readDefinition(definitionTree) : null;
    }

    private static boolean isPrivilegeDefinition(@NotNull Tree tree) {
        return "rep:Privilege".equals(TreeUtil.getPrimaryTypeName(tree));
    }
}

