/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import ch.qos.logback.classic.Level;
import org.apache.sling.tracer.internal.CallerStackReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TracerConfig
implements Comparable<TracerConfig> {
    private final String loggerName;
    private final Level level;
    private final int depth;
    private final CallerStackReporter callerReporter;

    public TracerConfig(String loggerName, Level level) {
        this(loggerName, level, null);
    }

    public TracerConfig(String loggerName, Level level, @Nullable CallerStackReporter reporter) {
        this.loggerName = loggerName;
        this.level = level;
        this.depth = TracerConfig.getDepth(loggerName);
        this.callerReporter = reporter;
    }

    public boolean match(String loggerName) {
        return loggerName.startsWith(this.loggerName);
    }

    public MatchResult match(String loggerName, Level level) {
        if (loggerName.startsWith(this.loggerName)) {
            if (level.isGreaterOrEqual(this.level)) {
                return MatchResult.MATCH_LOG;
            }
            return MatchResult.MATCH_NO_LOG;
        }
        return MatchResult.NO_MATCH;
    }

    @Override
    public int compareTo(@NotNull TracerConfig o) {
        int comp;
        int n = this.depth > o.depth ? -1 : (comp = this.depth < o.depth ? 1 : 0);
        if (comp == 0) {
            comp = this.loggerName.compareTo(o.loggerName);
        }
        return comp;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isReportCallerStack() {
        return this.callerReporter != null;
    }

    public CallerStackReporter getCallerReporter() {
        return this.callerReporter;
    }

    private static int getDepth(String loggerName) {
        int depth = 0;
        int fromIndex = 0;
        while (true) {
            int index = TracerConfig.getSeparatorIndexOf(loggerName, fromIndex);
            ++depth;
            if (index == -1) break;
            fromIndex = index + 1;
        }
        return depth;
    }

    private static int getSeparatorIndexOf(String name, int fromIndex) {
        int i = name.indexOf(46, fromIndex);
        if (i != -1) {
            return i;
        }
        return name.indexOf(36, fromIndex);
    }

    static enum MatchResult {
        MATCH_LOG,
        MATCH_NO_LOG,
        NO_MATCH;

    }
}

