/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.kickstart.run;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import org.apache.maven.plugin.logging.Log;

public class ControlClient {
    static final String COMMAND_STOP = "stop";
    static final String COMMAND_STATUS = "status";
    static final String COMMAND_THREADS = "threads";
    private static final String DEFAULT_LISTEN_INTERFACE = "127.0.0.1";
    private static final int DEFAULT_LISTEN_PORT = 0;
    private String secretKey;
    private InetSocketAddress socketAddress;
    private File directory;
    private Log logger;

    public ControlClient(File directory, Log logger) {
        this.directory = directory;
        this.logger = logger;
    }

    public int getPort() {
        return this.socketAddress != null ? this.socketAddress.getPort() : -1;
    }

    public boolean isStarted() {
        Response response = this.sendCommand(COMMAND_STATUS);
        return response.getCode() == 0 && "OK".equals(response.getResult());
    }

    public int shutdownServer() {
        return this.sendCommand(COMMAND_STOP).getCode();
    }

    public int statusServer() {
        return this.sendCommand(COMMAND_STATUS).getCode();
    }

    public int dumpThreads() {
        return this.sendCommand(COMMAND_THREADS).getCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response sendCommand(String command) {
        if (this.configure()) {
            if (this.secretKey == null) {
                this.logger.info((CharSequence)("Missing secret key to protect sending '" + command + "' to " + this.socketAddress));
                return new Response(4);
            }
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(this.socketAddress);
                this.writeLine0(socket, this.secretKey + " " + command);
                String result = this.readLine(socket);
                this.logger.info((CharSequence)("Sent '" + command + "' to " + this.socketAddress + ": " + result));
                Response response = new Response(0, result);
                return response;
            }
            catch (ConnectException ce) {
                this.logger.info((CharSequence)("No Apache Sling running at " + this.socketAddress));
                Response response = new Response(3, ce);
                return response;
            }
            catch (IOException ioe) {
                this.logger.error((CharSequence)("Failed sending '" + command + "' to " + this.socketAddress), (Throwable)ioe);
                Response response = new Response(1, ioe);
                return response;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logger.info((CharSequence)("No socket address to send '" + command + "' to"));
        return new Response(4);
    }

    private String readLine(Socket socket) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        StringBuilder b = new StringBuilder();
        boolean more = true;
        while (more) {
            String s = br.readLine();
            if (s != null && s.startsWith("-")) {
                s = s.substring(1);
            } else {
                more = false;
            }
            if (b.length() > 0) {
                b.append("\r\n");
            }
            b.append(s);
        }
        return b.toString();
    }

    private void writeLine0(Socket socket, String line) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        bw.write(line);
        bw.write("\r\n");
        bw.flush();
    }

    private boolean configure() {
        boolean result = false;
        File configFile = this.getConfigFile();
        if (configFile.canRead()) {
            try (LineNumberReader lnr = new LineNumberReader(new FileReader(configFile));){
                this.socketAddress = this.getSocketAddress(lnr.readLine());
                this.secretKey = lnr.readLine();
                result = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private File getConfigFile() {
        File configDir = new File(this.directory, "conf");
        return new File(configDir, "controlport");
    }

    private static String generateKey() {
        return new BigInteger(165, new SecureRandom()).toString(32);
    }

    private InetSocketAddress getSocketAddress(String listenSpec) {
        try {
            int port;
            String address;
            if (listenSpec == null) {
                address = DEFAULT_LISTEN_INTERFACE;
                port = 0;
            } else {
                int colon = listenSpec.indexOf(58);
                if (colon < 0) {
                    address = DEFAULT_LISTEN_INTERFACE;
                    port = Integer.parseInt(listenSpec);
                } else {
                    address = listenSpec.substring(0, colon);
                    port = Integer.parseInt(listenSpec.substring(colon + 1));
                }
            }
            InetSocketAddress addr = new InetSocketAddress(address, port);
            if (!addr.isUnresolved()) {
                return addr;
            }
            this.logger.error((CharSequence)("Unknown host in '" + listenSpec));
        }
        catch (NumberFormatException nfe) {
            this.logger.error((CharSequence)("Cannot parse port number from '" + listenSpec + "'"));
        }
        return null;
    }

    private static class Response {
        private int code;
        private String result;
        private Exception exception;

        public Response(int code) {
            this.code = code;
        }

        public Response(int code, String result) {
            this.code = code;
            this.result = result;
        }

        public Response(int code, Exception exception) {
            this.code = code;
            this.exception = exception;
        }

        public int getCode() {
            return this.code;
        }

        public String getResult() {
            return this.result;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

