/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.maven.bundlesupport.AbstractBundleInstallMojo;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

@Mojo(name="install-file", requiresProject=false)
public class BundleInstallFileMojo
extends AbstractBundleInstallMojo {
    @Parameter(property="sling.file", defaultValue="${project.build.directory}/${project.build.finalName}.jar")
    private File bundleFileName;
    @Parameter(property="sling.groupId")
    private String groupId;
    @Parameter(property="sling.artifactId")
    private String artifactId;
    @Parameter(property="sling.version")
    private String version;
    @Parameter(property="sling.packaging", defaultValue="jar")
    private String packaging = "jar";
    @Parameter(property="sling.classifier")
    private String classifier;
    @Parameter(property="sling.artifact")
    private String artifact;

    @Override
    protected File getBundleFileName() throws MojoExecutionException {
        File fileName = this.resolveBundleFileFromArtifact();
        if (fileName == null) {
            fileName = this.bundleFileName;
        } else if (this.mountByFS) {
            this.getLog().warn((CharSequence)"The parameter 'mountByFS' is only supported with files outside the Maven repository and therefore ignored in this context!");
            this.mountByFS = false;
        }
        if (fileName == null) {
            throw new MojoExecutionException("Must provide either sling.file, sling.artifact or sling.groupId/sling.artifactId/sling.version parameters");
        }
        return fileName;
    }

    private File resolveBundleFileFromArtifact() throws MojoExecutionException {
        if (this.artifactId == null && this.artifact == null) {
            return null;
        }
        if (this.artifactId == null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length != 3 && tokens.length != 4 && tokens.length != 5) {
                throw new MojoExecutionException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + this.artifact);
            }
            this.groupId = tokens[0];
            this.artifactId = tokens[1];
            this.version = tokens[2];
            if (tokens.length >= 4) {
                this.packaging = tokens[3];
            }
            if (tokens.length == 5) {
                this.classifier = tokens[4];
            }
        }
        File resolvedArtifactFile = this.resolveArtifact((Artifact)new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.packaging, this.version));
        this.getLog().info((CharSequence)("Resolved artifact to " + resolvedArtifactFile.getAbsolutePath()));
        return resolvedArtifactFile;
    }
}

