/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.fsresource;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.maven.bundlesupport.fsresource.FsMode;

class FsResourceConfiguration {
    private FsMode fsMode;
    private String resourceRootPath;
    private File fsRootPath;
    private String initialContentImportOptions;
    private String fileVaultFilterXml;

    FsResourceConfiguration() {
    }

    public FsMode getFsMode() {
        return this.fsMode;
    }

    public FsResourceConfiguration fsMode(FsMode value) {
        this.fsMode = value;
        return this;
    }

    public FsResourceConfiguration fsMode(String value) {
        this.fsMode = StringUtils.isBlank((CharSequence)value) ? null : FsMode.valueOf(StringUtils.upperCase((String)value));
        return this;
    }

    public String getResourceRootPath() {
        return this.resourceRootPath;
    }

    public FsResourceConfiguration resourceRootPath(String value) {
        this.resourceRootPath = value;
        return this;
    }

    public File getFsRootPath() {
        return this.fsRootPath;
    }

    public FsResourceConfiguration fsRootPath(File value) {
        if (!value.isAbsolute()) {
            throw new IllegalArgumentException("The given filesystem path must be absolute");
        }
        this.fsRootPath = value;
        return this;
    }

    public String getInitialContentImportOptions() {
        return this.initialContentImportOptions;
    }

    public FsResourceConfiguration initialContentImportOptions(String value) {
        this.initialContentImportOptions = value;
        return this;
    }

    public String getStringVaultFilterXml() {
        return this.fileVaultFilterXml;
    }

    public FsResourceConfiguration fileVaultFilterXml(String value) {
        this.fileVaultFilterXml = value;
        return this;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE);
    }
}

