/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.SimpleRequestExpectationManager;
import org.springframework.test.web.client.UnorderedRequestExpectationManager;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.support.RestGatewaySupport;

public final class MockRestServiceServer {
    private final RequestExpectationManager expectationManager;

    private MockRestServiceServer(RequestExpectationManager expectationManager) {
        this.expectationManager = expectationManager;
    }

    public ResponseActions expect(RequestMatcher matcher) {
        return this.expect(ExpectedCount.once(), matcher);
    }

    public ResponseActions expect(ExpectedCount count, RequestMatcher matcher) {
        return this.expectationManager.expectRequest(count, matcher);
    }

    public void verify() {
        this.expectationManager.verify();
    }

    public void verify(Duration timeout) {
        this.expectationManager.verify(timeout);
    }

    public void reset() {
        this.expectationManager.reset();
    }

    public static MockRestServiceServerBuilder bindTo(RestClient.Builder restClientBuilder) {
        return new RestClientMockRestServiceServerBuilder(restClientBuilder);
    }

    public static MockRestServiceServerBuilder bindTo(RestTemplate restTemplate) {
        return new RestTemplateMockRestServiceServerBuilder(restTemplate);
    }

    public static MockRestServiceServerBuilder bindTo(RestGatewaySupport restGatewaySupport) {
        Assert.notNull((Object)restGatewaySupport, (String)"'restGatewaySupport' must not be null");
        return new RestTemplateMockRestServiceServerBuilder(restGatewaySupport.getRestTemplate());
    }

    public static MockRestServiceServer createServer(RestTemplate restTemplate) {
        return MockRestServiceServer.bindTo(restTemplate).build();
    }

    public static MockRestServiceServer createServer(RestGatewaySupport restGateway) {
        return MockRestServiceServer.bindTo(restGateway).build();
    }

    private static class RestClientMockRestServiceServerBuilder
    extends AbstractMockRestServiceServerBuilder {
        private final RestClient.Builder restClientBuilder;

        RestClientMockRestServiceServerBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"RestClient.Builder must not be null");
            this.restClientBuilder = restClientBuilder;
        }

        @Override
        protected void injectRequestFactory(ClientHttpRequestFactory requestFactory) {
            this.restClientBuilder.requestFactory(requestFactory);
        }
    }

    private static class RestTemplateMockRestServiceServerBuilder
    extends AbstractMockRestServiceServerBuilder {
        private final RestTemplate restTemplate;

        RestTemplateMockRestServiceServerBuilder(RestTemplate restTemplate) {
            Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
            this.restTemplate = restTemplate;
        }

        @Override
        protected void injectRequestFactory(ClientHttpRequestFactory requestFactory) {
            this.restTemplate.setRequestFactory(requestFactory);
        }
    }

    public static interface MockRestServiceServerBuilder {
        public MockRestServiceServerBuilder ignoreExpectOrder(boolean var1);

        public MockRestServiceServerBuilder bufferContent();

        public MockRestServiceServer build();

        public MockRestServiceServer build(RequestExpectationManager var1);
    }

    private class MockClientHttpRequestFactory
    implements ClientHttpRequestFactory {
        private MockClientHttpRequestFactory() {
        }

        public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
            return this.createRequestInternal(uri, httpMethod);
        }

        private MockClientHttpRequest createRequestInternal(URI uri, HttpMethod httpMethod) {
            Assert.notNull((Object)uri, (String)"'uri' must not be null");
            Assert.notNull((Object)httpMethod, (String)"'httpMethod' must not be null");
            return new MockClientHttpRequest(httpMethod, uri){

                @Override
                protected ClientHttpResponse executeInternal() throws IOException {
                    ClientHttpResponse response = MockRestServiceServer.this.expectationManager.validateRequest(this);
                    this.setResponse(response);
                    return response;
                }
            };
        }
    }

    private static abstract class AbstractMockRestServiceServerBuilder
    implements MockRestServiceServerBuilder {
        private boolean ignoreExpectOrder;
        private boolean bufferContent;

        private AbstractMockRestServiceServerBuilder() {
        }

        @Override
        public MockRestServiceServerBuilder ignoreExpectOrder(boolean ignoreExpectOrder) {
            this.ignoreExpectOrder = ignoreExpectOrder;
            return this;
        }

        @Override
        public MockRestServiceServerBuilder bufferContent() {
            this.bufferContent = true;
            return this;
        }

        @Override
        public MockRestServiceServer build() {
            if (this.ignoreExpectOrder) {
                return this.build(new UnorderedRequestExpectationManager());
            }
            return this.build(new SimpleRequestExpectationManager());
        }

        @Override
        public MockRestServiceServer build(RequestExpectationManager manager) {
            MockRestServiceServer server = new MockRestServiceServer(manager);
            MockClientHttpRequestFactory factory = server.new MockClientHttpRequestFactory();
            if (this.bufferContent) {
                factory = new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)factory);
            }
            this.injectRequestFactory(factory);
            return server;
        }

        protected abstract void injectRequestFactory(ClientHttpRequestFactory var1);
    }
}

