/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.algorithms.glm_predict.Glm_means_and_vars_output;

public class GLM_predict
extends Script {
    public GLM_predict() {
        String string = "scripts/algorithms/GLM-predict.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix glm_partial_loglikelihood_for_power_dist_and_link(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/algorithms/GLM-predict.dml') as mlcontextns;log_l_part = mlcontextns::glm_partial_loglikelihood_for_power_dist_and_link(linear_terms, Y, var_power, link_power);";
        Script script = new Script(string);
        script.in("linear_terms", object).in("Y", object2).in("var_power", object3).in("link_power", object4).out("log_l_part");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("log_l_part");
        return matrix;
    }

    public String glm_partial_loglikelihood_for_power_dist_and_link__docs() {
        String string = "glm_partial_loglikelihood_for_power_dist_and_link =   # Assumes: dist_type == 1 & link_type == 1\n    function (Matrix[double] linear_terms, Matrix[double] Y, double var_power, double link_power)\n    return (Matrix[double] log_l_part)\n{\n    num_records = nrow (Y);\n    if (var_power == 1.0) { # Poisson\n        if (link_power == 0)  { # Poisson.log\n            is_natural_parameter_log_zero = (linear_terms == -Inf);\n            natural_parameters = replace (target = linear_terms, pattern = -Inf, replacement = 0);\n            b_cumulant = exp (linear_terms);\n        } else {                  # Poisson.power_nonlog\n            is_natural_parameter_log_zero = (linear_terms == 0);\n            natural_parameters = log (linear_terms + is_natural_parameter_log_zero) / link_power;\n            b_cumulant = (linear_terms + is_natural_parameter_log_zero) ^ (1.0 / link_power) - is_natural_parameter_log_zero;\n        }\n        is_minus_infinity = (Y > 0) * is_natural_parameter_log_zero;\n        log_l_part = Y * natural_parameters - b_cumulant - is_minus_infinity / (1 - is_minus_infinity);\n    } else {\n        if (var_power == 2.0 & link_power == 0)  { # Gamma.log\n            natural_parameters = - exp (- linear_terms);\n            b_cumulant = linear_terms;\n        } else if (var_power == 2.0)  { # Gamma.power_nonlog\n            natural_parameters = - linear_terms ^ (- 1.0 / link_power);\n            b_cumulant = log (linear_terms) / link_power;\n        } else if (link_power == 0) { # PowerDist.log\n            natural_parameters = exp (linear_terms * (1.0 - var_power)) / (1.0 - var_power);\n            b_cumulant = exp (linear_terms * (2.0 - var_power)) / (2.0 - var_power);\n        } else {                          # PowerDist.power_nonlog\n            power_np = (1.0 - var_power) / link_power;\n            natural_parameters = (linear_terms ^ power_np) / (1.0 - var_power);\n            power_cu = (2.0 - var_power) / link_power;\n            b_cumulant = (linear_terms ^ power_cu) / (2.0 - var_power);\n        }\n        log_l_part = Y * natural_parameters - b_cumulant;\n}   }\n";
        return string;
    }

    public String glm_partial_loglikelihood_for_power_dist_and_link__source() {
        String string = "glm_partial_loglikelihood_for_power_dist_and_link =   # Assumes: dist_type == 1 & link_type == 1\n    function (Matrix[double] linear_terms, Matrix[double] Y, double var_power, double link_power)\n    return (Matrix[double] log_l_part)\n{\n    num_records = nrow (Y);\n    if (var_power == 1.0) { # Poisson\n        if (link_power == 0)  { # Poisson.log\n            is_natural_parameter_log_zero = (linear_terms == -Inf);\n            natural_parameters = replace (target = linear_terms, pattern = -Inf, replacement = 0);\n            b_cumulant = exp (linear_terms);\n        } else {                  # Poisson.power_nonlog\n            is_natural_parameter_log_zero = (linear_terms == 0);\n            natural_parameters = log (linear_terms + is_natural_parameter_log_zero) / link_power;\n            b_cumulant = (linear_terms + is_natural_parameter_log_zero) ^ (1.0 / link_power) - is_natural_parameter_log_zero;\n        }\n        is_minus_infinity = (Y > 0) * is_natural_parameter_log_zero;\n        log_l_part = Y * natural_parameters - b_cumulant - is_minus_infinity / (1 - is_minus_infinity);\n    } else {\n        if (var_power == 2.0 & link_power == 0)  { # Gamma.log\n            natural_parameters = - exp (- linear_terms);\n            b_cumulant = linear_terms;\n        } else if (var_power == 2.0)  { # Gamma.power_nonlog\n            natural_parameters = - linear_terms ^ (- 1.0 / link_power);\n            b_cumulant = log (linear_terms) / link_power;\n        } else if (link_power == 0) { # PowerDist.log\n            natural_parameters = exp (linear_terms * (1.0 - var_power)) / (1.0 - var_power);\n            b_cumulant = exp (linear_terms * (2.0 - var_power)) / (2.0 - var_power);\n        } else {                          # PowerDist.power_nonlog\n            power_np = (1.0 - var_power) / link_power;\n            natural_parameters = (linear_terms ^ power_np) / (1.0 - var_power);\n            power_cu = (2.0 - var_power) / link_power;\n            b_cumulant = (linear_terms ^ power_cu) / (2.0 - var_power);\n        }\n        log_l_part = Y * natural_parameters - b_cumulant;\n}   }\n";
        return string;
    }

    public Glm_means_and_vars_output glm_means_and_vars(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/algorithms/GLM-predict.dml') as mlcontextns;[means, vars] = mlcontextns::glm_means_and_vars(linear_terms, dist_type, var_power, link_type, link_power);";
        Script script = new Script(string);
        script.in("linear_terms", object).in("dist_type", object2).in("var_power", object3).in("link_type", object4).in("link_power", object5).out("means").out("vars");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("means");
        Matrix matrix2 = mLResults.getMatrix("vars");
        Glm_means_and_vars_output glm_means_and_vars_output = new Glm_means_and_vars_output(matrix, matrix2);
        return glm_means_and_vars_output;
    }

    public String glm_means_and_vars__docs() {
        String string = "glm_means_and_vars = \n    function (Matrix[double] linear_terms, int dist_type, double var_power, int link_type, double link_power)\n    return (Matrix[double] means, Matrix[double] vars)\n    # NOTE: \"vars\" represents the variance without dispersion, i.e. the V(mu) function.\n{\n    num_points = nrow (linear_terms);\n    if (dist_type == 1 & link_type == 1) {\n    # POWER DISTRIBUTION\n        if          (link_power ==  0) {\n            y_mean = exp (linear_terms);\n        } else if (link_power ==  1.0) {\n            y_mean = linear_terms;\n        } else if (link_power == -1.0) {\n            y_mean = 1.0 / linear_terms;\n        } else {\n            y_mean = linear_terms ^ (1.0 / link_power);\n        }\n        if (var_power == 0) {\n            var_function = matrix (1.0, rows = num_points, cols = 1);\n        } else if (var_power == 1.0) {\n            var_function = y_mean;\n        } else {\n            var_function = y_mean ^ var_power;\n        }\n        means = y_mean;\n        vars = var_function;\n    } else if (dist_type == 2 & link_type >= 1 & link_type <= 5) {\n    # BINOMIAL/BERNOULLI DISTRIBUTION\n        y_prob = matrix (0.0, rows = num_points, cols = 2);\n        if          (link_type == 1 & link_power == 0)  { # Binomial.log\n            y_prob [, 1]  = exp (linear_terms);\n            y_prob [, 2]  = 1.0 - y_prob [, 1];\n        } else if (link_type == 1 & link_power != 0)  { # Binomial.power_nonlog\n            y_prob [, 1]  = linear_terms ^ (1.0 / link_power);\n            y_prob [, 2]  = 1.0 - y_prob [, 1];\n        } else if (link_type == 2)                      { # Binomial.logit\n            elt = exp (linear_terms);\n            y_prob [, 1]  = elt / (1.0 + elt);\n            y_prob [, 2]  = 1.0 / (1.0 + elt);\n        } else if (link_type == 3)                      { # Binomial.probit\n            sign_lt = 2 * (linear_terms >= 0) - 1;\n            t_gp = 1.0 / (1.0 + abs (linear_terms) * 0.231641888);  # 0.231641888 = 0.3275911 / sqrt (2.0)\n            erf_corr =\n                t_gp * ( 0.254829592 \n              + t_gp * (-0.284496736 # \"Handbook of Mathematical Functions\", ed. by M. Abramowitz and I.A. Stegun,\n              + t_gp * ( 1.421413741 # U.S. Nat-l Bureau of Standards, 10th print (Dec 1972), Sec. 7.1.26, p. 299\n              + t_gp * (-1.453152027 \n              + t_gp *   1.061405429)))) * sign_lt * exp (- (linear_terms ^ 2) / 2.0);\n            y_prob [, 1] = (1 + sign_lt) - erf_corr;\n            y_prob [, 2] = (1 - sign_lt) + erf_corr;\n            y_prob = y_prob / 2;\n        } else if (link_type == 4)                      { # Binomial.cloglog\n            elt = exp (linear_terms);\n            is_too_small = ((10000000 + elt) == 10000000);\n            y_prob [, 2] = exp (- elt);\n            y_prob [, 1] = (1 - is_too_small) * (1.0 - y_prob [, 2]) + is_too_small * elt * (1.0 - elt / 2);\n        } else if (link_type == 5)                      { # Binomial.cauchit\n            atan_linear_terms = atan (linear_terms);\n            y_prob [, 1] = 0.5 + atan_linear_terms / pi;\n            y_prob [, 2] = 0.5 - atan_linear_terms / pi;\n        }\n        means = y_prob;\n        ones_ctg = matrix (1, rows = 2, cols = 1);\n        vars  = means * (means %*% (1 - diag (ones_ctg)));\n    } else if (dist_type == 3) {\n    # MULTINOMIAL LOGIT DISTRIBUTION\n        elt = exp (linear_terms);\n        ones_pts = matrix (1, rows = num_points, cols = 1);\n        elt = cbind (elt, ones_pts);\n        ones_ctg = matrix (1, rows = ncol (elt), cols = 1);\n        means = elt / (rowSums (elt) %*% t(ones_ctg));\n        vars  = means * (means %*% (1 - diag (ones_ctg)));\n    } else {\n        means = matrix (0.0, rows = num_points, cols = 1);\n        vars  = matrix (0.0, rows = num_points, cols = 1);\n}   }\n";
        return string;
    }

    public String glm_means_and_vars__source() {
        String string = "glm_means_and_vars = \n    function (Matrix[double] linear_terms, int dist_type, double var_power, int link_type, double link_power)\n    return (Matrix[double] means, Matrix[double] vars)\n    # NOTE: \"vars\" represents the variance without dispersion, i.e. the V(mu) function.\n{\n    num_points = nrow (linear_terms);\n    if (dist_type == 1 & link_type == 1) {\n    # POWER DISTRIBUTION\n        if          (link_power ==  0) {\n            y_mean = exp (linear_terms);\n        } else if (link_power ==  1.0) {\n            y_mean = linear_terms;\n        } else if (link_power == -1.0) {\n            y_mean = 1.0 / linear_terms;\n        } else {\n            y_mean = linear_terms ^ (1.0 / link_power);\n        }\n        if (var_power == 0) {\n            var_function = matrix (1.0, rows = num_points, cols = 1);\n        } else if (var_power == 1.0) {\n            var_function = y_mean;\n        } else {\n            var_function = y_mean ^ var_power;\n        }\n        means = y_mean;\n        vars = var_function;\n    } else if (dist_type == 2 & link_type >= 1 & link_type <= 5) {\n    # BINOMIAL/BERNOULLI DISTRIBUTION\n        y_prob = matrix (0.0, rows = num_points, cols = 2);\n        if          (link_type == 1 & link_power == 0)  { # Binomial.log\n            y_prob [, 1]  = exp (linear_terms);\n            y_prob [, 2]  = 1.0 - y_prob [, 1];\n        } else if (link_type == 1 & link_power != 0)  { # Binomial.power_nonlog\n            y_prob [, 1]  = linear_terms ^ (1.0 / link_power);\n            y_prob [, 2]  = 1.0 - y_prob [, 1];\n        } else if (link_type == 2)                      { # Binomial.logit\n            elt = exp (linear_terms);\n            y_prob [, 1]  = elt / (1.0 + elt);\n            y_prob [, 2]  = 1.0 / (1.0 + elt);\n        } else if (link_type == 3)                      { # Binomial.probit\n            sign_lt = 2 * (linear_terms >= 0) - 1;\n            t_gp = 1.0 / (1.0 + abs (linear_terms) * 0.231641888);  # 0.231641888 = 0.3275911 / sqrt (2.0)\n            erf_corr =\n                t_gp * ( 0.254829592 \n              + t_gp * (-0.284496736 # \"Handbook of Mathematical Functions\", ed. by M. Abramowitz and I.A. Stegun,\n              + t_gp * ( 1.421413741 # U.S. Nat-l Bureau of Standards, 10th print (Dec 1972), Sec. 7.1.26, p. 299\n              + t_gp * (-1.453152027 \n              + t_gp *   1.061405429)))) * sign_lt * exp (- (linear_terms ^ 2) / 2.0);\n            y_prob [, 1] = (1 + sign_lt) - erf_corr;\n            y_prob [, 2] = (1 - sign_lt) + erf_corr;\n            y_prob = y_prob / 2;\n        } else if (link_type == 4)                      { # Binomial.cloglog\n            elt = exp (linear_terms);\n            is_too_small = ((10000000 + elt) == 10000000);\n            y_prob [, 2] = exp (- elt);\n            y_prob [, 1] = (1 - is_too_small) * (1.0 - y_prob [, 2]) + is_too_small * elt * (1.0 - elt / 2);\n        } else if (link_type == 5)                      { # Binomial.cauchit\n            atan_linear_terms = atan (linear_terms);\n            y_prob [, 1] = 0.5 + atan_linear_terms / pi;\n            y_prob [, 2] = 0.5 - atan_linear_terms / pi;\n        }\n        means = y_prob;\n        ones_ctg = matrix (1, rows = 2, cols = 1);\n        vars  = means * (means %*% (1 - diag (ones_ctg)));\n    } else if (dist_type == 3) {\n    # MULTINOMIAL LOGIT DISTRIBUTION\n        elt = exp (linear_terms);\n        ones_pts = matrix (1, rows = num_points, cols = 1);\n        elt = cbind (elt, ones_pts);\n        ones_ctg = matrix (1, rows = ncol (elt), cols = 1);\n        means = elt / (rowSums (elt) %*% t(ones_ctg));\n        vars  = means * (means %*% (1 - diag (ones_ctg)));\n    } else {\n        means = matrix (0.0, rows = num_points, cols = 1);\n        vars  = matrix (0.0, rows = num_points, cols = 1);\n}   }\n";
        return string;
    }
}

