/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ListObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.io.FileFormatProperties;
import org.apache.sysml.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.WriterMatrixMarket;
import org.apache.sysml.runtime.io.WriterTextCSV;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.ProgramConverter;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.Statistics;

public class VariableCPInstruction
extends CPInstruction {
    private static final IDSequence _uniqueVarID = new IDSequence(true);
    private static final int CREATEVAR_FILE_NAME_VAR_POS = 3;
    private final VariableOperationCode opcode;
    private final List<CPOperand> inputs;
    private final CPOperand output;
    private final MetaData metadata;
    private final MatrixObject.UpdateType _updateType;
    private final String _schema;
    private final FileFormatProperties _formatProperties;

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, MetaData meta, FileFormatProperties fprops, String schema, MatrixObject.UpdateType utype, String sopcode, String istr) {
        super(CPInstruction.CPType.Variable, sopcode, istr);
        this.opcode = op;
        this.inputs = new ArrayList<CPOperand>();
        this.addInput(in1);
        this.addInput(in2);
        this.addInput(in3);
        this.output = out;
        this.metadata = meta;
        this._formatProperties = fprops;
        this._schema = schema;
        this._updateType = utype;
    }

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String sopcode, String istr) {
        this(op, in1, in2, in3, out, null, null, null, null, sopcode, istr);
    }

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, MetaData md, MatrixObject.UpdateType updateType, String schema, String sopcode, String istr) {
        this(op, in1, in2, in3, null, md, null, schema, updateType, sopcode, istr);
    }

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, MetaData md, MatrixObject.UpdateType updateType, FileFormatProperties formatProperties, String schema, String sopcode, String istr) {
        this(op, in1, in2, in3, null, md, formatProperties, schema, updateType, sopcode, istr);
    }

    private static VariableOperationCode getVariableOperationCode(String str) {
        if (str.equalsIgnoreCase("createvar")) {
            return VariableOperationCode.CreateVariable;
        }
        if (str.equalsIgnoreCase("assignvar")) {
            return VariableOperationCode.AssignVariable;
        }
        if (str.equalsIgnoreCase("cpvar")) {
            return VariableOperationCode.CopyVariable;
        }
        if (str.equalsIgnoreCase("mvvar")) {
            return VariableOperationCode.MoveVariable;
        }
        if (str.equalsIgnoreCase("rmvar")) {
            return VariableOperationCode.RemoveVariable;
        }
        if (str.equalsIgnoreCase("rmfilevar")) {
            return VariableOperationCode.RemoveVariableAndFile;
        }
        if (str.equalsIgnoreCase("castdts")) {
            return VariableOperationCode.CastAsScalarVariable;
        }
        if (str.equalsIgnoreCase("castdtm")) {
            return VariableOperationCode.CastAsMatrixVariable;
        }
        if (str.equalsIgnoreCase("castdtf")) {
            return VariableOperationCode.CastAsFrameVariable;
        }
        if (str.equalsIgnoreCase("castvtd")) {
            return VariableOperationCode.CastAsDoubleVariable;
        }
        if (str.equalsIgnoreCase("castvti")) {
            return VariableOperationCode.CastAsIntegerVariable;
        }
        if (str.equalsIgnoreCase("castvtb")) {
            return VariableOperationCode.CastAsBooleanVariable;
        }
        if (str.equalsIgnoreCase("write")) {
            return VariableOperationCode.Write;
        }
        if (str.equalsIgnoreCase("read")) {
            return VariableOperationCode.Read;
        }
        if (str.equalsIgnoreCase("setfilename")) {
            return VariableOperationCode.SetFileName;
        }
        throw new DMLRuntimeException("Invalid function: " + str);
    }

    public boolean isRemoveVariable(String varName) {
        if (this.isRemoveVariable()) {
            for (CPOperand input : this.inputs) {
                if (!input.getName().equalsIgnoreCase(varName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRemoveVariableNoFile() {
        return this.opcode == VariableOperationCode.RemoveVariable;
    }

    public boolean isRemoveVariable() {
        return this.opcode == VariableOperationCode.RemoveVariable || this.opcode == VariableOperationCode.RemoveVariableAndFile;
    }

    public boolean isAssignVariable() {
        return this.opcode == VariableOperationCode.AssignVariable;
    }

    public FileFormatProperties getFormatProperties() {
        return this._formatProperties;
    }

    public List<CPOperand> getInputs() {
        return this.inputs;
    }

    public CPOperand getInput1() {
        return this.getInput(0);
    }

    public CPOperand getInput2() {
        return this.getInput(1);
    }

    public CPOperand getInput3() {
        return this.getInput(2);
    }

    public CPOperand getInput4() {
        return this.getInput(3);
    }

    public CPOperand getInput(int index) {
        if (this.inputs.size() <= index) {
            return null;
        }
        return this.inputs.get(index);
    }

    public void addInput(CPOperand input) {
        if (input != null) {
            this.inputs.add(input);
        }
    }

    public String getOutputVariableName() {
        String ret = null;
        if (this.output != null) {
            ret = this.output.getName();
        }
        return ret;
    }

    private static int getArity(VariableOperationCode op) {
        switch (op) {
            case Write: 
            case SetFileName: {
                return 3;
            }
        }
        return 2;
    }

    public static VariableCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        VariableOperationCode voc = VariableCPInstruction.getVariableOperationCode(opcode);
        if (voc == VariableOperationCode.CreateVariable) {
            if (parts.length < 5) {
                throw new DMLRuntimeException("Invalid number of operands in createvar instruction: " + str);
            }
        } else if (voc == VariableOperationCode.MoveVariable) {
            if (parts.length != 3 && parts.length != 4) {
                throw new DMLRuntimeException("Invalid number of operands in mvvar instruction: " + str);
            }
        } else if (voc == VariableOperationCode.Write) {
            if (parts.length != 5 && parts.length != 8) {
                throw new DMLRuntimeException("Invalid number of operands in write instruction: " + str);
            }
        } else if (voc != VariableOperationCode.RemoveVariable) {
            InstructionUtils.checkNumFields(parts, VariableCPInstruction.getArity(voc));
        }
        CPOperand in1 = null;
        CPOperand in2 = null;
        CPOperand in3 = null;
        CPOperand in4 = null;
        CPOperand out = null;
        switch (voc) {
            case CreateVariable: {
                String schema;
                Expression.DataType dt = Expression.DataType.valueOf(parts[4]);
                Expression.ValueType vt = dt == Expression.DataType.MATRIX ? Expression.ValueType.DOUBLE : Expression.ValueType.STRING;
                int extSchema = dt == Expression.DataType.FRAME && parts.length >= 13 ? 1 : 0;
                in1 = new CPOperand(parts[1], vt, dt);
                in2 = new CPOperand(parts[2], Expression.ValueType.STRING, Expression.DataType.SCALAR);
                in3 = new CPOperand(parts[3], Expression.ValueType.BOOLEAN, Expression.DataType.SCALAR);
                String fmt = parts[5];
                if (fmt.equalsIgnoreCase("csv") ? parts.length < 15 + extSchema || parts.length > 17 + extSchema : parts.length != 6 && parts.length != 12 + extSchema) {
                    throw new DMLRuntimeException("Invalid number of operands in createvar instruction: " + str);
                }
                OutputInfo oi = OutputInfo.stringToOutputInfo(fmt);
                InputInfo ii = OutputInfo.getMatchingInputInfo(oi);
                MatrixCharacteristics mc = new MatrixCharacteristics();
                if (parts.length != 6) {
                    if (parts.length >= 11) {
                        mc.setDimension(Long.parseLong(parts[6]), Long.parseLong(parts[7]));
                        mc.setBlockSize(Integer.parseInt(parts[8]), Integer.parseInt(parts[9]));
                        mc.setNonZeros(Long.parseLong(parts[10]));
                    } else {
                        throw new DMLRuntimeException("Invalid number of operands in createvar instruction: " + str);
                    }
                }
                MetaDataFormat iimd = new MetaDataFormat(mc, oi, ii);
                MatrixObject.UpdateType updateType = MatrixObject.UpdateType.COPY;
                if (parts.length >= 12) {
                    updateType = MatrixObject.UpdateType.valueOf(parts[11].toUpperCase());
                }
                String string = schema = dt == Expression.DataType.FRAME && parts.length >= 13 ? parts[parts.length - 1] : null;
                if (fmt.equalsIgnoreCase("csv")) {
                    FileFormatPropertiesCSV fmtProperties = null;
                    if (parts.length == 15 + extSchema) {
                        boolean hasHeader = Boolean.parseBoolean(parts[12]);
                        String delim = parts[13];
                        boolean sparse = Boolean.parseBoolean(parts[14]);
                        fmtProperties = new FileFormatPropertiesCSV(hasHeader, delim, sparse);
                    } else {
                        boolean hasHeader = Boolean.parseBoolean(parts[12]);
                        String delim = parts[13];
                        boolean fill = Boolean.parseBoolean(parts[14]);
                        double fillValue = UtilFunctions.parseToDouble(parts[15]);
                        String naStrings = null;
                        if (parts.length == 17 + extSchema) {
                            naStrings = parts[16];
                        }
                        fmtProperties = new FileFormatPropertiesCSV(hasHeader, delim, fill, fillValue, naStrings);
                    }
                    return new VariableCPInstruction(VariableOperationCode.CreateVariable, in1, in2, in3, iimd, updateType, fmtProperties, schema, opcode, str);
                }
                return new VariableCPInstruction(VariableOperationCode.CreateVariable, in1, in2, in3, iimd, updateType, schema, opcode, str);
            }
            case AssignVariable: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2]);
                break;
            }
            case CopyVariable: {
                in1 = new CPOperand(parts[1], Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
                in2 = new CPOperand(parts[2], Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
                break;
            }
            case MoveVariable: {
                in1 = new CPOperand(parts[1], Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
                in2 = new CPOperand(parts[2], Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
                if (parts.length <= 3) break;
                in3 = new CPOperand(parts[3], Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
                break;
            }
            case RemoveVariable: {
                VariableCPInstruction rminst = new VariableCPInstruction(VariableCPInstruction.getVariableOperationCode(opcode), null, null, null, out, opcode, str);
                for (int i = 1; i < parts.length; ++i) {
                    rminst.addInput(new CPOperand(parts[i], Expression.ValueType.UNKNOWN, Expression.DataType.SCALAR));
                }
                return rminst;
            }
            case RemoveVariableAndFile: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2]);
                if (in2.getValueType() == Expression.ValueType.BOOLEAN) break;
                throw new DMLRuntimeException("Unexpected value type for second argument in: " + str);
            }
            case CastAsScalarVariable: 
            case CastAsMatrixVariable: 
            case CastAsFrameVariable: 
            case CastAsDoubleVariable: 
            case CastAsIntegerVariable: 
            case CastAsBooleanVariable: {
                in1 = new CPOperand(parts[1]);
                out = new CPOperand(parts[2]);
                break;
            }
            case Write: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2]);
                in3 = new CPOperand(parts[3]);
                FileFormatProperties fprops = null;
                if (in3.getName().equalsIgnoreCase("csv")) {
                    boolean hasHeader = Boolean.parseBoolean(parts[4]);
                    String delim = parts[5];
                    boolean sparse = Boolean.parseBoolean(parts[6]);
                    fprops = new FileFormatPropertiesCSV(hasHeader, delim, sparse);
                    in4 = new CPOperand(parts[7]);
                } else {
                    fprops = new FileFormatProperties();
                    in4 = new CPOperand(parts[4]);
                }
                VariableCPInstruction inst = new VariableCPInstruction(VariableCPInstruction.getVariableOperationCode(opcode), in1, in2, in3, out, null, fprops, null, null, opcode, str);
                inst.addInput(in4);
                return inst;
            }
            case Read: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2]);
                out = null;
                break;
            }
            case SetFileName: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2], Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
                in3 = new CPOperand(parts[3], Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
            }
        }
        return new VariableCPInstruction(VariableCPInstruction.getVariableOperationCode(opcode), in1, in2, in3, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        switch (this.opcode) {
            case CreateVariable: {
                if (this.getInput1().getDataType() == Expression.DataType.MATRIX) {
                    String fname = this.getInput2().getName();
                    if (Boolean.parseBoolean(this.getInput3().getName())) {
                        fname = new StringBuilder(fname.length() + 16).append(fname).append('_').append(_uniqueVarID.getNextID()).toString();
                    }
                    MatrixObject mobj = new MatrixObject(this.getInput1().getValueType(), fname);
                    mobj.setMetaData((MetaData)this.metadata.clone());
                    mobj.setFileFormatProperties(this._formatProperties);
                    mobj.setUpdateType(this._updateType);
                    mobj.enableCleanup(!this.getInput1().getName().startsWith(org.apache.sysml.lops.Data.PREAD_PREFIX));
                    ec.setVariable(this.getInput1().getName(), mobj);
                    if (!DMLScript.STATISTICS || !this._updateType.isInPlace()) break;
                    Statistics.incrementTotalUIPVar();
                    break;
                }
                if (this.getInput1().getDataType() == Expression.DataType.FRAME) {
                    String fname = this.getInput2().getName();
                    FrameObject fobj = new FrameObject(fname);
                    fobj.setMetaData((MetaData)this.metadata.clone());
                    fobj.setFileFormatProperties(this._formatProperties);
                    if (this._schema != null) {
                        fobj.setSchema(this._schema);
                    }
                    fobj.enableCleanup(!this.getInput1().getName().startsWith(org.apache.sysml.lops.Data.PREAD_PREFIX));
                    ec.setVariable(this.getInput1().getName(), fobj);
                    break;
                }
                if (this.getInput1().getDataType() == Expression.DataType.SCALAR) {
                    ec.setScalarOutput(this.getInput1().getName(), null);
                    break;
                }
                throw new DMLRuntimeException("Unexpected data type: " + (Object)((Object)this.getInput1().getDataType()));
            }
            case AssignVariable: {
                ec.setScalarOutput(this.getInput2().getName(), ec.getScalarInput(this.getInput1()));
                break;
            }
            case CopyVariable: {
                this.processCopyInstruction(ec);
                break;
            }
            case MoveVariable: {
                this.processMoveInstruction(ec);
                break;
            }
            case RemoveVariable: {
                for (CPOperand input : this.inputs) {
                    VariableCPInstruction.processRemoveVariableInstruction(ec, input.getName());
                }
                break;
            }
            case RemoveVariableAndFile: {
                boolean del = ((BooleanObject)ec.getScalarInput(this.getInput2().getName(), this.getInput2().getValueType(), true)).getBooleanValue();
                MatrixObject m = (MatrixObject)ec.removeVariable(this.getInput1().getName());
                if (!del) {
                    if (m.isDirty()) {
                        m.exportData();
                    }
                } else {
                    VariableCPInstruction.cleanDataOnHDFS(m);
                }
                if (ec.getVariables().hasReferences(m)) break;
                m.clearData();
                break;
            }
            case CastAsScalarVariable: {
                if (this.getInput1().getDataType().isFrame()) {
                    FrameBlock fBlock = ec.getFrameInput(this.getInput1().getName());
                    if (fBlock.getNumRows() != 1 || fBlock.getNumColumns() != 1) {
                        throw new DMLRuntimeException("Dimension mismatch - unable to cast frame '" + this.getInput1().getName() + "' of dimension (" + fBlock.getNumRows() + " x " + fBlock.getNumColumns() + ") to scalar.");
                    }
                    Object value = fBlock.get(0, 0);
                    ec.releaseFrameInput(this.getInput1().getName());
                    ec.setScalarOutput(this.output.getName(), ScalarObjectFactory.createScalarObject(fBlock.getSchema()[0], value));
                    break;
                }
                if (this.getInput1().getDataType().isMatrix()) {
                    MatrixBlock mBlock = ec.getMatrixInput(this.getInput1().getName(), this.getExtendedOpcode());
                    if (mBlock.getNumRows() != 1 || mBlock.getNumColumns() != 1) {
                        throw new DMLRuntimeException("Dimension mismatch - unable to cast matrix '" + this.getInput1().getName() + "' of dimension (" + mBlock.getNumRows() + " x " + mBlock.getNumColumns() + ") to scalar.");
                    }
                    double value = mBlock.getValue(0, 0);
                    ec.releaseMatrixInput(this.getInput1().getName(), this.getExtendedOpcode());
                    ec.setScalarOutput(this.output.getName(), new DoubleObject(value));
                    break;
                }
                if (this.getInput1().getDataType().isList()) {
                    ListObject list = (ListObject)ec.getVariable(this.getInput1().getName());
                    ec.setVariable(this.output.getName(), list.slice(0));
                    break;
                }
                throw new DMLRuntimeException("Unsupported data type in as.scalar(): " + this.getInput1().getDataType().name());
            }
            case CastAsMatrixVariable: {
                if (this.getInput1().getDataType().isFrame()) {
                    FrameBlock fin = ec.getFrameInput(this.getInput1().getName());
                    MatrixBlock out = DataConverter.convertToMatrixBlock(fin);
                    ec.releaseFrameInput(this.getInput1().getName());
                    ec.setMatrixOutput(this.output.getName(), out, this.getExtendedOpcode());
                    break;
                }
                if (this.getInput1().getDataType().isScalar()) {
                    ScalarObject scalarInput = ec.getScalarInput(this.getInput1().getName(), this.getInput1().getValueType(), this.getInput1().isLiteral());
                    MatrixBlock out = new MatrixBlock(scalarInput.getDoubleValue());
                    ec.setMatrixOutput(this.output.getName(), out, this.getExtendedOpcode());
                    break;
                }
                if (this.getInput1().getDataType().isList()) {
                    ListObject list = (ListObject)ec.getVariable(this.getInput1().getName());
                    if (list.getLength() > 1) {
                        if (!list.checkAllDataTypes(Expression.DataType.SCALAR)) {
                            throw new DMLRuntimeException("as.matrix over multi-entry list only allows scalars.");
                        }
                        MatrixBlock out = new MatrixBlock(list.getLength(), 1, false);
                        for (int i = 0; i < list.getLength(); ++i) {
                            out.quickSetValue(i, 0, ((ScalarObject)list.slice(i)).getDoubleValue());
                        }
                        ec.setMatrixOutput(this.output.getName(), out, this.getExtendedOpcode());
                        break;
                    }
                    Data tmp = list.slice(0);
                    if (tmp instanceof ScalarObject && tmp.getValueType() != Expression.ValueType.STRING) {
                        MatrixBlock out = new MatrixBlock(((ScalarObject)tmp).getDoubleValue());
                        ec.setMatrixOutput(this.output.getName(), out, this.getExtendedOpcode());
                        break;
                    }
                    ec.setVariable(this.output.getName(), tmp);
                    break;
                }
                throw new DMLRuntimeException("Unsupported data type in as.matrix(): " + this.getInput1().getDataType().name());
            }
            case CastAsFrameVariable: {
                FrameBlock out = null;
                if (this.getInput1().getDataType() == Expression.DataType.SCALAR) {
                    ScalarObject scalarInput = ec.getScalarInput(this.getInput1());
                    out = new FrameBlock(1, this.getInput1().getValueType());
                    out.ensureAllocatedColumns(1);
                    out.set(0, 0, scalarInput.getStringValue());
                } else {
                    MatrixBlock min = ec.getMatrixInput(this.getInput1().getName(), this.getExtendedOpcode());
                    out = DataConverter.convertToFrameBlock(min);
                    ec.releaseMatrixInput(this.getInput1().getName(), this.getExtendedOpcode());
                }
                ec.setFrameOutput(this.output.getName(), out);
                break;
            }
            case CastAsDoubleVariable: {
                ScalarObject in = ec.getScalarInput(this.getInput1());
                ec.setScalarOutput(this.output.getName(), ScalarObjectFactory.castToDouble(in));
                break;
            }
            case CastAsIntegerVariable: {
                ScalarObject in = ec.getScalarInput(this.getInput1());
                ec.setScalarOutput(this.output.getName(), ScalarObjectFactory.castToLong(in));
                break;
            }
            case CastAsBooleanVariable: {
                ScalarObject scalarInput = ec.getScalarInput(this.getInput1());
                ec.setScalarOutput(this.output.getName(), new BooleanObject(scalarInput.getBooleanValue()));
                break;
            }
            case Read: {
                ScalarObject res = null;
                try {
                    switch (this.getInput1().getValueType()) {
                        case DOUBLE: {
                            double d = MapReduceTool.readDoubleFromHDFSFile(this.getInput2().getName());
                            res = new DoubleObject(d);
                            break;
                        }
                        case INT: {
                            long i = MapReduceTool.readIntegerFromHDFSFile(this.getInput2().getName());
                            res = new IntObject(i);
                            break;
                        }
                        case BOOLEAN: {
                            boolean b = MapReduceTool.readBooleanFromHDFSFile(this.getInput2().getName());
                            res = new BooleanObject(b);
                            break;
                        }
                        case STRING: {
                            String s = MapReduceTool.readStringFromHDFSFile(this.getInput2().getName());
                            res = new StringObject(s);
                            break;
                        }
                        default: {
                            throw new DMLRuntimeException("Invalid value type (" + (Object)((Object)this.getInput1().getValueType()) + ") while processing readScalar instruction.");
                        }
                    }
                }
                catch (IOException e) {
                    throw new DMLRuntimeException(e);
                }
                ec.setScalarOutput(this.getInput1().getName(), res);
                break;
            }
            case Write: {
                this.processWriteInstruction(ec);
                break;
            }
            case SetFileName: {
                Data data = ec.getVariable(this.getInput1().getName());
                if (data.getDataType() == Expression.DataType.MATRIX) {
                    if (this.getInput3().getName().equalsIgnoreCase("remote")) {
                        ((MatrixObject)data).setFileName(this.getInput2().getName());
                        break;
                    }
                    throw new DMLRuntimeException("Invalid location (" + this.getInput3().getName() + ") in SetFileName instruction: " + this.instString);
                }
                throw new DMLRuntimeException("Invalid data type (" + (Object)((Object)this.getInput1().getDataType()) + ") in SetFileName instruction: " + this.instString);
            }
            default: {
                throw new DMLRuntimeException("Unknown opcode: " + (Object)((Object)this.opcode));
            }
        }
    }

    private void processMoveInstruction(ExecutionContext ec) {
        if (this.getInput3() == null) {
            Data tgt;
            Data srcData = ec.getVariable(this.getInput1().getName());
            if (srcData == null) {
                throw new DMLRuntimeException("Unexpected error: could not find a data object for variable name:" + this.getInput1().getName() + ", while processing instruction ");
            }
            if ((this.getInput2().getDataType().isMatrix() || this.getInput2().getDataType().isFrame()) && (tgt = ec.removeVariable(this.getInput2().getName())) != null) {
                ec.cleanupDataObject(tgt);
            }
            ec.setVariable(this.getInput2().getName(), srcData);
            ec.removeVariable(this.getInput1().getName());
        } else {
            if (ec.getVariable(this.getInput1().getName()) == null) {
                throw new DMLRuntimeException("Unexpected error: could not find a data object for variable name:" + this.getInput1().getName() + ", while processing instruction " + this.toString());
            }
            Data object = ec.getVariable(this.getInput1().getName());
            if (this.getInput3().getName().equalsIgnoreCase("binaryblock")) {
                boolean success = false;
                success = ((CacheableData)object).moveData(this.getInput2().getName(), this.getInput3().getName());
                if (!success) {
                    throw new DMLRuntimeException("Failed to move var " + this.getInput1().getName() + " to file " + this.getInput2().getName() + ".");
                }
            } else {
                if (object instanceof MatrixObject) {
                    throw new DMLRuntimeException("Unexpected formats while copying: from matrix blocks [" + ((MatrixObject)object).getNumRowsPerBlock() + "," + ((MatrixObject)object).getNumColumnsPerBlock() + "] to " + this.getInput3().getName());
                }
                if (object instanceof FrameObject) {
                    throw new DMLRuntimeException("Unexpected formats while copying: from fram object [" + ((FrameObject)object).getNumColumns() + "," + ((FrameObject)object).getNumColumns() + "] to " + this.getInput3().getName());
                }
            }
        }
    }

    private void processCopyInstruction(ExecutionContext ec) {
        Data dd = ec.getVariable(this.getInput1().getName());
        if (dd == null) {
            throw new DMLRuntimeException("Unexpected error: could not find a data object for variable name:" + this.getInput1().getName() + ", while processing instruction " + this.toString());
        }
        Data input2_data = ec.removeVariable(this.getInput2().getName());
        if (input2_data != null) {
            ec.cleanupDataObject(input2_data);
        }
        ec.setVariable(this.getInput2().getName(), dd);
    }

    private void processWriteInstruction(ExecutionContext ec) {
        String fname = ec.getScalarInput(this.getInput2().getName(), Expression.ValueType.STRING, this.getInput2().isLiteral()).getStringValue();
        String desc = ec.getScalarInput(this.getInput4().getName(), Expression.ValueType.STRING, this.getInput4().isLiteral()).getStringValue();
        this._formatProperties.setDescription(desc);
        if (this.getInput1().getDataType() == Expression.DataType.SCALAR) {
            this.writeScalarToHDFS(ec, fname);
        } else if (this.getInput1().getDataType() == Expression.DataType.MATRIX) {
            String outFmt = this.getInput3().getName();
            if (outFmt.equalsIgnoreCase("matrixmarket")) {
                this.writeMMFile(ec, fname);
            } else if (outFmt.equalsIgnoreCase("csv")) {
                this.writeCSVFile(ec, fname);
            } else {
                MatrixObject mo = ec.getMatrixObject(this.getInput1().getName());
                mo.exportData(fname, outFmt, this._formatProperties);
            }
        } else if (this.getInput1().getDataType() == Expression.DataType.FRAME) {
            String outFmt = this.getInput3().getName();
            FrameObject mo = ec.getFrameObject(this.getInput1().getName());
            mo.exportData(fname, outFmt, this._formatProperties);
        }
    }

    public static void processRemoveVariableInstruction(ExecutionContext ec, String varname) {
        Data dat = ec.removeVariable(varname);
        if (dat != null) {
            ec.cleanupDataObject(dat);
        }
    }

    private void writeCSVFile(ExecutionContext ec, String fname) {
        MatrixObject mo = ec.getMatrixObject(this.getInput1().getName());
        String outFmt = "csv";
        if (mo.isDirty()) {
            mo.exportData(fname, outFmt, this._formatProperties);
        } else {
            try {
                OutputInfo oi = ((MetaDataFormat)mo.getMetaData()).getOutputInfo();
                MatrixCharacteristics mc = ((MetaDataFormat)mo.getMetaData()).getMatrixCharacteristics();
                if (oi == OutputInfo.CSVOutputInfo) {
                    WriterTextCSV writer = new WriterTextCSV((FileFormatPropertiesCSV)this._formatProperties);
                    writer.addHeaderToCSV(mo.getFileName(), fname, mc.getRows(), mc.getCols());
                } else if (oi == OutputInfo.BinaryBlockOutputInfo || oi == OutputInfo.TextCellOutputInfo) {
                    mo.exportData(fname, outFmt, this._formatProperties);
                } else {
                    throw new DMLRuntimeException("Unexpected data format (" + OutputInfo.outputInfoToString(oi) + "): can not export into CSV format.");
                }
                MapReduceTool.writeMetaDataFile(fname + ".mtd", mo.getValueType(), mc, OutputInfo.CSVOutputInfo, this._formatProperties);
            }
            catch (IOException e) {
                throw new DMLRuntimeException(e);
            }
        }
    }

    private void writeMMFile(ExecutionContext ec, String fname) {
        MatrixObject mo = ec.getMatrixObject(this.getInput1().getName());
        String outFmt = "matrixmarket";
        if (mo.isDirty()) {
            mo.exportData(fname, outFmt);
        } else {
            OutputInfo oi = ((MetaDataFormat)mo.getMetaData()).getOutputInfo();
            MatrixCharacteristics mc = mo.getMatrixCharacteristics();
            if (oi == OutputInfo.TextCellOutputInfo) {
                try {
                    WriterMatrixMarket.mergeTextcellToMatrixMarket(mo.getFileName(), fname, mc.getRows(), mc.getCols(), mc.getNonZeros());
                }
                catch (IOException e) {
                    throw new DMLRuntimeException(e);
                }
            } else if (oi == OutputInfo.BinaryBlockOutputInfo) {
                mo.exportData(fname, outFmt);
            } else {
                throw new DMLRuntimeException("Unexpected data format (" + OutputInfo.outputInfoToString(oi) + "): can not export into MatrixMarket format.");
            }
        }
    }

    private void writeScalarToHDFS(ExecutionContext ec, String fname) {
        try {
            ScalarObject scalar = ec.getScalarInput(this.getInput1().getName(), this.getInput1().getValueType(), this.getInput1().isLiteral());
            MapReduceTool.writeObjectToHDFS(scalar.getValue(), fname);
            MapReduceTool.writeScalarMetaDataFile(fname + ".mtd", this.getInput1().getValueType());
            FileSystem fs = IOUtilFunctions.getFileSystem(fname);
            if (fs instanceof LocalFileSystem) {
                Path path = new Path(fname);
                IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
            }
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static void cleanDataOnHDFS(MatrixObject mo) {
        try {
            String fpath = mo.getFileName();
            if (fpath != null) {
                MapReduceTool.deleteFileIfExistOnHDFS(fpath);
                MapReduceTool.deleteFileIfExistOnHDFS(fpath + ".mtd");
            }
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }

    public static Instruction prepareRemoveInstruction(String ... varNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("CP");
        sb.append("\u00b0");
        sb.append("rmvar");
        for (String varName : varNames) {
            sb.append("\u00b0");
            sb.append(varName);
        }
        return VariableCPInstruction.parseInstruction(sb.toString());
    }

    public static Instruction prepareCopyInstruction(String srcVar, String destVar) {
        StringBuilder sb = new StringBuilder();
        sb.append("CP");
        sb.append("\u00b0");
        sb.append("cpvar");
        sb.append("\u00b0");
        sb.append(srcVar);
        sb.append("\u00b0");
        sb.append(destVar);
        return VariableCPInstruction.parseInstruction(sb.toString());
    }

    public static Instruction prepareMoveInstruction(String srcVar, String destFileName, String format) {
        StringBuilder sb = new StringBuilder();
        sb.append("CP");
        sb.append("\u00b0");
        sb.append("mvvar");
        sb.append("\u00b0");
        sb.append(srcVar);
        sb.append("\u00b0");
        sb.append(destFileName);
        sb.append("\u00b0");
        sb.append(format);
        String str = sb.toString();
        return VariableCPInstruction.parseInstruction(str);
    }

    public static Instruction prepareMoveInstruction(String srcVar, String destVar) {
        StringBuilder sb = new StringBuilder();
        sb.append("CP");
        sb.append("\u00b0");
        sb.append("mvvar");
        sb.append("\u00b0");
        sb.append(srcVar);
        sb.append("\u00b0");
        sb.append(destVar);
        String str = sb.toString();
        return VariableCPInstruction.parseInstruction(str);
    }

    private static String getBasicCreateVarString(String varName, String fileName, boolean fNameOverride, Expression.DataType dt, String format) {
        boolean lfNameOverride = fNameOverride && !ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_TEMPORARY_FILENAMES);
        StringBuilder sb = new StringBuilder();
        sb.append("CP");
        sb.append("\u00b0");
        sb.append("createvar");
        sb.append("\u00b0");
        sb.append(varName);
        sb.append("\u00b0");
        sb.append(fileName);
        sb.append("\u00b0");
        sb.append(lfNameOverride);
        sb.append("\u00b0");
        sb.append(dt.toString());
        sb.append("\u00b0");
        sb.append(format);
        return sb.toString();
    }

    public static Instruction prepareCreateMatrixVariableInstruction(String varName, String fileName, boolean fNameOverride, String format) {
        return VariableCPInstruction.parseInstruction(VariableCPInstruction.getBasicCreateVarString(varName, fileName, fNameOverride, Expression.DataType.MATRIX, format));
    }

    public static Instruction prepareCreateVariableInstruction(String varName, String fileName, boolean fNameOverride, Expression.DataType dt, String format, MatrixCharacteristics mc, MatrixObject.UpdateType update) {
        StringBuilder sb = new StringBuilder();
        sb.append(VariableCPInstruction.getBasicCreateVarString(varName, fileName, fNameOverride, dt, format));
        sb.append("\u00b0");
        sb.append(mc.getRows());
        sb.append("\u00b0");
        sb.append(mc.getCols());
        sb.append("\u00b0");
        sb.append(mc.getRowsPerBlock());
        sb.append("\u00b0");
        sb.append(mc.getColsPerBlock());
        sb.append("\u00b0");
        sb.append(mc.getNonZeros());
        sb.append("\u00b0");
        sb.append(update.toString().toLowerCase());
        String str = sb.toString();
        return VariableCPInstruction.parseInstruction(str);
    }

    public static Instruction prepareCreateVariableInstruction(String varName, String fileName, boolean fNameOverride, Expression.DataType dt, String format, MatrixCharacteristics mc, MatrixObject.UpdateType update, boolean hasHeader, String delim, boolean sparse) {
        StringBuilder sb = new StringBuilder();
        sb.append(VariableCPInstruction.getBasicCreateVarString(varName, fileName, fNameOverride, dt, format));
        sb.append("\u00b0");
        sb.append(mc.getRows());
        sb.append("\u00b0");
        sb.append(mc.getCols());
        sb.append("\u00b0");
        sb.append(mc.getRowsPerBlock());
        sb.append("\u00b0");
        sb.append(mc.getColsPerBlock());
        sb.append("\u00b0");
        sb.append(mc.getNonZeros());
        sb.append("\u00b0");
        sb.append(update.toString().toLowerCase());
        sb.append("\u00b0");
        sb.append(hasHeader);
        sb.append("\u00b0");
        sb.append(delim);
        sb.append("\u00b0");
        sb.append(sparse);
        String str = sb.toString();
        return VariableCPInstruction.parseInstruction(str);
    }

    @Override
    public void updateInstructionThreadID(String pattern, String replace) {
        if (this.opcode == VariableOperationCode.CreateVariable || this.opcode == VariableOperationCode.SetFileName) {
            this.getInput2().setName(this.getInput2().getName().replaceAll(pattern, replace));
            int iPos = StringUtils.ordinalIndexOf(this.instString, "\u00b0", 3);
            int iPos2 = StringUtils.indexOf(this.instString, "\u00b0", iPos + 1);
            StringBuilder sb = new StringBuilder();
            sb.append(this.instString.substring(0, iPos + 1));
            sb.append(ProgramConverter.saveReplaceFilenameThreadID(this.instString.substring(iPos + 1, iPos2 + 1), pattern, replace));
            sb.append(this.instString.substring(iPos2 + 1));
            this.instString = sb.toString();
        }
    }

    public boolean isVariableCastInstruction() {
        return this.opcode == VariableOperationCode.CastAsScalarVariable || this.opcode == VariableOperationCode.CastAsMatrixVariable || this.opcode == VariableOperationCode.CastAsFrameVariable || this.opcode == VariableOperationCode.CastAsIntegerVariable || this.opcode == VariableOperationCode.CastAsDoubleVariable || this.opcode == VariableOperationCode.CastAsBooleanVariable;
    }

    private static enum VariableOperationCode {
        CreateVariable,
        AssignVariable,
        CopyVariable,
        MoveVariable,
        RemoveVariable,
        RemoveVariableAndFile,
        CastAsScalarVariable,
        CastAsMatrixVariable,
        CastAsFrameVariable,
        CastAsDoubleVariable,
        CastAsIntegerVariable,
        CastAsBooleanVariable,
        Write,
        Read,
        SetFileName;

    }
}

