/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.services.InvalidationEventHub;

public class RecomputableSupport {
    private volatile int masterVersion = 1;

    public void invalidate() {
        ++this.masterVersion;
    }

    public void initialize(InvalidationEventHub hub) {
        hub.addInvalidationCallback(new Runnable(){

            @Override
            public void run() {
                RecomputableSupport.this.invalidate();
            }
        });
    }

    public <T> Invokable<T> create(final Invokable<T> invokable) {
        return new Invokable<T>(){
            private volatile int localVersion;
            private volatile T cachedResult;
            {
                this.localVersion = RecomputableSupport.this.masterVersion;
            }

            public T invoke() {
                if (this.localVersion != RecomputableSupport.this.masterVersion) {
                    this.cachedResult = null;
                    this.localVersion = RecomputableSupport.this.masterVersion;
                }
                if (this.cachedResult == null) {
                    this.cachedResult = invokable.invoke();
                }
                return this.cachedResult;
            }
        };
    }
}

