/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.validator;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.javascript.DataConstants;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.validator.AbstractValidator;

public final class MaxLength
extends AbstractValidator<Integer, String> {
    public MaxLength(JavaScriptSupport javaScriptSupport) {
        super(Integer.class, String.class, "maximum-string-length", javaScriptSupport);
    }

    @Override
    public void validate(Field field, Integer constraintValue, MessageFormatter formatter, String value) throws ValidationException {
        if (value.length() > constraintValue) {
            throw new ValidationException(this.buildMessage(formatter, field, constraintValue));
        }
    }

    private String buildMessage(MessageFormatter formatter, Field field, Integer constraintValue) {
        return formatter.format(new Object[]{constraintValue, field.getLabel()});
    }

    @Override
    public void render(Field field, Integer constraintValue, MessageFormatter formatter, MarkupWriter writer, FormSupport formSupport) {
        if (formSupport.isClientValidationEnabled()) {
            this.javaScriptSupport.require("t5/core/validation");
            writer.attributes(DataConstants.VALIDATION_ATTRIBUTE, true, "data-validate-max-length", constraintValue.toString(), "data-max-length-message", this.buildMessage(formatter, field, constraintValue));
        }
    }
}

