/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.tapestry5.internal.jpa.CommitAfterMethodAdvice;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.jpa.EntityTransactionManager;
import org.apache.tapestry5.jpa.JpaTransactionAdvisor;
import org.apache.tapestry5.jpa.annotations.CommitAfter;
import org.apache.tapestry5.plastic.MethodAdvice;

public class JpaTransactionAdvisorImpl
implements JpaTransactionAdvisor {
    private final Map<String, MethodAdvice> methodAdvices;

    public JpaTransactionAdvisorImpl(EntityManagerManager manager, EntityTransactionManager transactionManager) {
        this.methodAdvices = new HashMap<String, MethodAdvice>(manager.getEntityManagers().size());
        for (Map.Entry<String, EntityManager> entry : manager.getEntityManagers().entrySet()) {
            this.methodAdvices.put(entry.getKey(), new CommitAfterMethodAdvice(transactionManager, entry.getKey()));
        }
        this.methodAdvices.put(null, new CommitAfterMethodAdvice(transactionManager, null));
    }

    @Override
    public void addTransactionCommitAdvice(MethodAdviceReceiver receiver) {
        for (Method m : receiver.getInterface().getMethods()) {
            if (m.getAnnotation(CommitAfter.class) == null) continue;
            PersistenceContext annotation = (PersistenceContext)receiver.getMethodAnnotation(m, PersistenceContext.class);
            receiver.adviseMethod(m, this.methodAdvices.get(annotation == null ? null : annotation.unitName()));
        }
    }
}

