// Copyright 2009, 2011 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.internal.pageload;

import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

/**
 * Provides access to {@link org.apache.tapestry5.internal.pageload.ComponentAssembler}s (this is used by the assemblers
 * to find related assemblers).
 */
public interface ComponentAssemblerSource
{
    /**
     * Gets (and possibly creates) a component assembler for the indicated class name and selector.
     */
    public ComponentAssembler getAssembler(String className, ComponentResourceSelector selector);
}
