/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.ObjectStreamException;
import javax.measure.UnitConverter;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.ConcatenatedConverter;
import org.apache.sis.measure.LinearConverter;

final class PowerOf10
extends AbstractConverter {
    private static final long serialVersionUID = 7960860506196831772L;
    private static final double LN_10 = 2.302585092994046;
    private static final UnitConverter INSTANCE = new PowerOf10();

    static UnitConverter belToOne() {
        return new ConcatenatedConverter(LinearConverter.scale(1.0, 2.0), INSTANCE);
    }

    private PowerOf10() {
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    @Override
    public UnitConverter inverse() {
        return Logarithm.INSTANCE;
    }

    @Override
    public double convert(double value) {
        return MathFunctions.pow10(value);
    }

    @Override
    public double derivative(double value) {
        return 2.302585092994046 * MathFunctions.pow10(value);
    }

    public boolean equals(Object other) {
        return other instanceof PowerOf10;
    }

    public int hashCode() {
        return -1303613924;
    }

    public String toString() {
        return "y = 10^x";
    }

    private static final class Logarithm
    extends AbstractConverter {
        private static final long serialVersionUID = -7089883299592861677L;
        static final UnitConverter INSTANCE = new Logarithm();

        private Logarithm() {
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        @Override
        public UnitConverter inverse() {
            return INSTANCE;
        }

        @Override
        public double convert(double value) {
            return Math.log10(value);
        }

        @Override
        public double derivative(double value) {
            return 1.0 / (value * 2.302585092994046);
        }

        public int hashCode() {
            return -322238445;
        }

        public boolean equals(Object other) {
            return other instanceof Logarithm;
        }

        public String toString() {
            return "y = log10(x)";
        }
    }
}

