/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.sis.io.TableAppender;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class ProjectedTransformTry
implements Comparable<ProjectedTransformTry>,
Map.Entry<String, MathTransform> {
    private static final int BUFFER_CAPACITY = 512;
    private final String name;
    final MathTransform projection;
    private final int[] projToGrid;
    final boolean reverseAfterLinearization;
    float correlation;
    private TransformException error;

    ProjectedTransformTry(ProjectedTransformTry other) {
        this.name = other.name;
        this.projection = other.projection;
        this.projToGrid = other.projToGrid;
        this.reverseAfterLinearization = other.reverseAfterLinearization;
    }

    ProjectedTransformTry(String name, MathTransform projection, int[] projToGrid, int expectedDimension, boolean reverseAfterLinearization) {
        ArgumentChecks.ensureNonNull("name", name);
        ArgumentChecks.ensureNonNull("projection", projection);
        this.name = name;
        this.projection = projection;
        this.projToGrid = projToGrid;
        this.reverseAfterLinearization = reverseAfterLinearization;
        int side = 0;
        int actual = projection.getSourceDimensions();
        if (actual <= expectedDimension && actual == (expectedDimension = projToGrid.length)) {
            actual = projection.getTargetDimensions();
            if (actual == expectedDimension) {
                return;
            }
            side = 1;
        }
        throw new MismatchedDimensionException(Errors.format((short)190, name, side, expectedDimension, actual));
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public MathTransform getValue() {
        LinearTransform mt = MathTransforms.linear(Matrices.createDimensionSelect(this.projToGrid.length, this.projToGrid));
        return MathTransforms.concatenate(mt, this.projection);
    }

    @Override
    public MathTransform setValue(MathTransform value) {
        throw new UnsupportedOperationException();
    }

    final double[][] transform(double[][] coordinates, int numPoints, Queue<double[]> pool) {
        int numDimensions = this.projToGrid.length;
        double[][] results = new double[numDimensions][];
        for (int i = 0; i < numDimensions; ++i) {
            results[i] = pool.poll();
            if (results[i] != null) continue;
            results[i] = new double[numPoints];
        }
        try {
            if (numDimensions == 1) {
                this.projection.transform(coordinates[this.projToGrid[0]], 0, results[0], 0, numPoints);
            } else {
                int bufferCapacity = Math.min(numPoints, 512);
                double[] buffer = new double[bufferCapacity * numDimensions];
                int dataOffset = 0;
                while (dataOffset < numPoints) {
                    int dst;
                    double[] data;
                    int d;
                    int start = dataOffset;
                    int stop = Math.min(start + bufferCapacity, numPoints);
                    for (d = 0; d < numDimensions; ++d) {
                        data = coordinates[this.projToGrid[d]];
                        dataOffset = start;
                        dst = d;
                        do {
                            buffer[dst] = data[dataOffset];
                            dst += numDimensions;
                        } while (++dataOffset < stop);
                    }
                    this.projection.transform(buffer, 0, buffer, 0, stop - start);
                    for (d = 0; d < numDimensions; ++d) {
                        data = results[d];
                        dataOffset = start;
                        dst = d;
                        do {
                            if (!Double.isFinite(data[dataOffset] = buffer[dst])) {
                                ProjectedTransformTry.recycle(results, pool);
                                return null;
                            }
                            dst += numDimensions;
                        } while (++dataOffset < stop);
                    }
                }
            }
        }
        catch (TransformException e) {
            this.error = e;
            ProjectedTransformTry.recycle(results, pool);
            return null;
        }
        return results;
    }

    static void recycle(double[][] arrays, Queue<double[]> pool) {
        if (arrays != null) {
            Collections.addAll(pool, arrays);
        }
    }

    private boolean useSameDimensions() {
        return ArraysExt.isRange(0, this.projToGrid);
    }

    final double[][] replaceTransformed(double[][] targets, double[][] newValues) {
        if (newValues.length == targets.length && this.useSameDimensions()) {
            return newValues;
        }
        targets = (double[][])targets.clone();
        for (int j = 0; j < this.projToGrid.length; ++j) {
            targets[this.projToGrid[j]] = newValues[j];
        }
        return targets;
    }

    final double[] replaceTransformed(double[] correlations, double[] newValues) {
        if (newValues.length == correlations.length && this.useSameDimensions()) {
            return newValues;
        }
        correlations = (double[])correlations.clone();
        for (int j = 0; j < this.projToGrid.length; ++j) {
            correlations[this.projToGrid[j]] = newValues[j];
        }
        return correlations;
    }

    final MatrixSIS replaceTransformed(MatrixSIS transform, MatrixSIS newValues) {
        assert (newValues.getNumCol() == transform.getNumCol());
        if (newValues.getNumRow() == transform.getNumRow() && this.useSameDimensions()) {
            return newValues;
        }
        transform = transform.clone();
        for (int j = 0; j < this.projToGrid.length; ++j) {
            int d = this.projToGrid[j];
            int i = transform.getNumCol();
            while (--i >= 0) {
                transform.setNumber(d, i, newValues.getNumber(j, i));
            }
        }
        return transform;
    }

    static TransformException getError(List<ProjectedTransformTry> linearizers) {
        TransformException error = null;
        for (ProjectedTransformTry alt : linearizers) {
            TransformException e = alt.error;
            if (e == null) continue;
            if (error == null) {
                error = e;
                continue;
            }
            error.addSuppressed(e);
        }
        return error;
    }

    @Override
    public int compareTo(ProjectedTransformTry other) {
        return Float.compare(-this.correlation, -other.correlation);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)obj;
            return this.name.equals(other.getKey()) && this.projection.equals(other.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ this.projection.hashCode();
    }

    final NumberFormat summarize(TableAppender table, NumberFormat nf, Locale locale) {
        table.append(this.name).nextColumn();
        String message = "";
        if (this.error != null) {
            message = Exceptions.getLocalizedMessage(this.error, locale);
            if (message == null) {
                message = this.error.getClass().getSimpleName();
            }
        } else if (this.correlation > 0.0f) {
            if (nf == null) {
                nf = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
                nf.setMinimumFractionDigits(6);
                nf.setMaximumFractionDigits(6);
            }
            message = nf.format(this.correlation);
        }
        table.append(message).nextLine();
        return nf;
    }

    public String toString() {
        TableAppender buffer = new TableAppender("  ");
        this.summarize(buffer, null, null);
        return buffer.toString();
    }
}

