/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.csv;

import java.io.IOException;
import java.time.DateTimeException;
import java.util.Collection;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.storage.csv.FixedSizeList;
import org.apache.sis.storage.csv.GeometryParser;
import org.apache.sis.storage.csv.Store;
import org.apache.sis.storage.csv.TimeEncoding;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.BackingStoreException;

class FeatureIterator
implements Spliterator<AbstractFeature> {
    static final int TRAJECTORY_COLUMN = 3;
    final Store store;
    final String[] propertyNames;
    final ObjectConverter<String, ?>[] converters;
    final Object[] values;
    private AtomicInteger splitCount;

    FeatureIterator(Store store) {
        this.store = store;
        Collection<AbstractIdentifiedType> properties = store.featureType.getProperties(true);
        this.converters = new ObjectConverter[properties.size()];
        this.values = new Object[this.converters.length];
        this.propertyNames = new String[this.converters.length];
        int i = -1;
        for (AbstractIdentifiedType p : properties) {
            ObjectConverter<String, double[]> c;
            this.propertyNames[++i] = p.getName().tip().toString();
            switch (i) {
                case 1: 
                case 2: {
                    TimeEncoding timeEncoding = store.timeEncoding();
                    if (timeEncoding != null) {
                        c = timeEncoding;
                        break;
                    }
                }
                case 3: {
                    if (store.hasTrajectories()) {
                        c = GeometryParser.INSTANCE;
                        break;
                    }
                }
                default: {
                    c = ObjectConverters.find(String.class, ((DefaultAttributeType)p).getValueClass());
                }
            }
            this.converters[i] = c;
        }
    }

    private FeatureIterator(FeatureIterator other) {
        this.store = other.store;
        this.splitCount = other.splitCount;
        this.converters = other.converters;
        this.propertyNames = other.propertyNames;
        this.values = new Object[this.converters.length];
    }

    @Override
    public Spliterator<AbstractFeature> trySplit() {
        if (this.splitCount == null) {
            this.splitCount = new AtomicInteger();
        }
        if (this.splitCount.incrementAndGet() < 8) {
            return new FeatureIterator(this);
        }
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AbstractFeature> action) {
        try {
            return this.read(action, false);
        }
        catch (IOException | IllegalArgumentException | DateTimeException e) {
            throw new BackingStoreException(this.store.canNotParseFile(), e);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super AbstractFeature> action) {
        try {
            this.read(action, true);
        }
        catch (IOException | IllegalArgumentException | DateTimeException e) {
            throw new BackingStoreException(this.store.canNotParseFile(), e);
        }
    }

    private boolean read(Consumer<? super AbstractFeature> action, boolean all) throws IOException {
        String line;
        FixedSizeList elements = new FixedSizeList(this.values);
        while ((line = this.store.readLine()) != null) {
            int i;
            Store.split(line, elements);
            AbstractFeature feature = this.store.featureType.newInstance();
            int n = elements.size();
            for (i = 0; i < n; ++i) {
                this.values[i] = this.converters[i].apply((String)this.values[i]);
                feature.setPropertyValue(this.propertyNames[i], this.values[i]);
            }
            n = this.values.length;
            while (i < n) {
                feature.setPropertyValue(this.propertyNames[i], this.values[i]);
                ++i;
            }
            action.accept(feature);
            if (!all) {
                return true;
            }
            elements.clear();
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1280;
    }
}

