/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class UnidataObsConvention
extends CoordSysBuilder {
    public UnidataObsConvention() {
        this.conventionName = "Unidata Observation Dataset v1.0";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        VariableEnhanced ve;
        Variable v;
        String vname;
        if (!(this.hasAxisType(ds, AxisType.Lat) || this.addAxisType(ds, "latitude", AxisType.Lat) || this.addAxisType(ds, vname = ds.findAttValueIgnoreCase(null, "latitude_coordinate", null), AxisType.Lat) || (v = this.hasUnits(ds, "degrees_north,degrees_N,degreesN,degree_north,degree_N,degreeN")) == null)) {
            this.addAxisType(v, AxisType.Lat);
        }
        if (!(this.hasAxisType(ds, AxisType.Lon) || this.addAxisType(ds, "longitude", AxisType.Lon) || this.addAxisType(ds, vname = ds.findAttValueIgnoreCase(null, "longitude_coordinate", null), AxisType.Lon) || (v = this.hasUnits(ds, "degrees_east,degrees_E,degreesE,degree_east,degree_E,degreeE")) == null)) {
            this.addAxisType(v, AxisType.Lon);
        }
        if (!(this.hasAxisType(ds, AxisType.Height) || this.addAxisType(ds, "altitude", AxisType.Height) || this.addAxisType(ds, "depth", AxisType.Height) || this.addAxisType(ds, vname = ds.findAttValueIgnoreCase(null, "altitude_coordinate", null), AxisType.Height))) {
            for (int i = 0; i < ds.getVariables().size(); ++i) {
                ve = (VariableEnhanced)((Object)ds.getVariables().get(i));
                String positive = ds.findAttValueIgnoreCase((Variable)((Object)ve), "positive", null);
                if (positive == null) continue;
                this.addAxisType((Variable)((Object)ve), AxisType.Height);
                break;
            }
        }
        if (!(this.hasAxisType(ds, AxisType.Time) || this.addAxisType(ds, "time", AxisType.Time) || this.addAxisType(ds, vname = ds.findAttValueIgnoreCase(null, "time_coordinate", null), AxisType.Time))) {
            for (int i = 0; i < ds.getVariables().size(); ++i) {
                ve = (VariableEnhanced)((Object)ds.getVariables().get(i));
                String unit = ve.getUnitsString();
                if (unit == null || !SimpleUnit.isDateUnit(unit)) continue;
                this.addAxisType((Variable)((Object)ve), AxisType.Time);
                break;
            }
        }
    }

    private boolean hasAxisType(NetcdfDataset ds, AxisType a) {
        List<Variable> varList = ds.getVariables();
        for (Variable v : varList) {
            String axisType = ds.findAttValueIgnoreCase(v, "CoordinateAxisType", null);
            if (axisType == null || !axisType.equals(a.toString())) continue;
            return true;
        }
        return false;
    }

    private Variable hasUnits(NetcdfDataset ds, String unitList) {
        List<Variable> varList = ds.getVariables();
        StringTokenizer stoker = new StringTokenizer(unitList, ",");
        while (stoker.hasMoreTokens()) {
            String unit = stoker.nextToken();
            for (Variable ve : varList) {
                String hasUnit = ve.getUnitsString();
                if (hasUnit == null || !hasUnit.equalsIgnoreCase(unit)) continue;
                return ve;
            }
        }
        return null;
    }

    private boolean addAxisType(NetcdfDataset ds, String vname, AxisType a) {
        if (vname == null) {
            return false;
        }
        Variable v = ds.findVariable(vname);
        if (v == null) {
            return false;
        }
        this.addAxisType(v, a);
        return true;
    }

    private void addAxisType(Variable v, AxisType a) {
        v.addAttribute(new Attribute("_CoordinateAxisType", a.toString()));
    }
}

