/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;

public final class TinkerIndexHelper {
    private TinkerIndexHelper() {
    }

    public static List<TinkerVertex> queryVertexIndex(AbstractTinkerGraph graph, String key, Object value) {
        return null == graph.vertexIndex ? Collections.emptyList() : graph.vertexIndex.get(key, value);
    }

    public static List<TinkerEdge> queryEdgeIndex(AbstractTinkerGraph graph, String key, Object value) {
        return null == graph.edgeIndex ? Collections.emptyList() : graph.edgeIndex.get(key, value);
    }

    public static void autoUpdateIndex(TinkerEdge edge, String key, Object newValue, Object oldValue) {
        AbstractTinkerGraph graph = (AbstractTinkerGraph)edge.graph();
        if (graph.edgeIndex != null) {
            graph.edgeIndex.autoUpdate(key, newValue, oldValue, edge);
        }
    }

    public static void autoUpdateIndex(TinkerVertex vertex, String key, Object newValue, Object oldValue) {
        AbstractTinkerGraph graph = (AbstractTinkerGraph)vertex.graph();
        if (graph.vertexIndex != null) {
            graph.vertexIndex.autoUpdate(key, newValue, oldValue, vertex);
        }
    }

    public static void removeElementIndex(TinkerVertex vertex) {
        AbstractTinkerGraph graph = (AbstractTinkerGraph)vertex.graph();
        if (graph.vertexIndex != null) {
            graph.vertexIndex.removeElement(vertex);
        }
    }

    public static void removeElementIndex(TinkerEdge edge) {
        AbstractTinkerGraph graph = (AbstractTinkerGraph)edge.graph();
        if (graph.edgeIndex != null) {
            graph.edgeIndex.removeElement(edge);
        }
    }

    public static void removeIndex(TinkerVertex vertex, String key, Object value) {
        AbstractTinkerGraph graph = (AbstractTinkerGraph)vertex.graph();
        if (graph.vertexIndex != null) {
            graph.vertexIndex.remove(key, value, vertex);
        }
    }

    public static void removeIndex(TinkerEdge edge, String key, Object value) {
        AbstractTinkerGraph graph = (AbstractTinkerGraph)edge.graph();
        if (graph.edgeIndex != null) {
            graph.edgeIndex.remove(key, value, edge);
        }
    }
}

