/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.util;

import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.structure.Graph;

public final class GraphComputerHelper {
    private GraphComputerHelper() {
    }

    public static void validateProgramOnComputer(GraphComputer computer, VertexProgram vertexProgram) {
        if (vertexProgram.getMemoryComputeKeys().contains(null)) {
            throw Memory.Exceptions.memoryKeyCanNotBeNull();
        }
        if (vertexProgram.getMemoryComputeKeys().contains("")) {
            throw Memory.Exceptions.memoryKeyCanNotBeEmpty();
        }
        GraphComputer.Features graphComputerFeatures = computer.features();
        VertexProgram.Features vertexProgramFeatures = vertexProgram.getFeatures();
        for (Method method : VertexProgram.Features.class.getMethods()) {
            boolean requires;
            boolean supports;
            if (!method.getName().startsWith("requires")) continue;
            try {
                supports = (Boolean)GraphComputer.Features.class.getMethod(method.getName().replace("requires", "supports"), new Class[0]).invoke((Object)graphComputerFeatures, new Object[0]);
                requires = (Boolean)method.invoke((Object)vertexProgramFeatures, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("A reflection exception has occurred: " + e.getMessage(), e);
            }
            if (!requires || supports) continue;
            throw new IllegalStateException("The vertex program can not be executed on the graph computer: " + method.getName());
        }
    }

    public static GraphComputer.ResultGraph getResultGraphState(Optional<VertexProgram> vertexProgram, Optional<GraphComputer.ResultGraph> resultGraph) {
        return resultGraph.isPresent() ? resultGraph.get() : (vertexProgram.isPresent() ? vertexProgram.get().getPreferredResultGraph() : GraphComputer.ResultGraph.ORIGINAL);
    }

    public static GraphComputer.Persist getPersistState(Optional<VertexProgram> vertexProgram, Optional<GraphComputer.Persist> persist) {
        return persist.isPresent() ? persist.get() : (vertexProgram.isPresent() ? vertexProgram.get().getPreferredPersist() : GraphComputer.Persist.NOTHING);
    }

    public static boolean areEqual(MapReduce a, Object b) {
        if (null == a) {
            throw Graph.Exceptions.argumentCanNotBeNull("a");
        }
        if (null == b) {
            throw Graph.Exceptions.argumentCanNotBeNull("b");
        }
        if (!(b instanceof MapReduce)) {
            return false;
        }
        return a.getClass().equals(b.getClass()) && a.getMemoryKey().equals(((MapReduce)b).getMemoryKey());
    }
}

