/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;

public final class GraphMigrator {
    private GraphMigrator() {
    }

    public static void migrateGraph(Graph fromGraph, Graph toGraph) throws IOException {
        GraphMigrator.migrateGraph(fromGraph, toGraph, fromGraph.io(IoCore.gryo()).reader().create(), toGraph.io(IoCore.gryo()).writer().create());
    }

    public static void migrateGraph(Graph fromGraph, Graph toGraph, GraphReader reader, GraphWriter writer) throws IOException {
        final PipedInputStream inPipe = new PipedInputStream(1024);
        PipedOutputStream outPipe = new PipedOutputStream(inPipe){

            @Override
            public void close() throws IOException {
                while (inPipe.available() > 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                super.close();
            }
        };
        new Thread(() -> {
            try {
                writer.writeGraph(outPipe, fromGraph);
                outPipe.flush();
                outPipe.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (fromGraph.features().graph().supportsTransactions()) {
                    fromGraph.tx().rollback();
                }
                if (toGraph.features().graph().supportsTransactions()) {
                    toGraph.tx().rollback();
                }
            }
        }).start();
        reader.readGraph(inPipe, toGraph);
    }
}

