/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.PasswordFactory;

public abstract class CryptoStreamFactoryTemplate
implements CryptoStreamFactory {
    protected static CryptoStreamFactory instance;

    public static CryptoStreamFactory getInstance() {
        return instance;
    }

    public static void setInstance(CryptoStreamFactory instance) {
        CryptoStreamFactoryTemplate.instance = instance;
    }

    @Override
    public InputStream getInputStream(InputStream is, String decryptionMode) throws GeneralSecurityException, IOException {
        InputStream result = null;
        result = "auto".equalsIgnoreCase(decryptionMode) ? this.getSmartInputStream(is) : ("true".equalsIgnoreCase(decryptionMode) ? this.getInputStream(is) : is);
        return result;
    }

    @Override
    public InputStream getInputStream(InputStream is, String decryptionMode, char[] password) throws GeneralSecurityException, IOException {
        InputStream result = null;
        result = "auto".equalsIgnoreCase(decryptionMode) ? this.getSmartInputStream(is, password) : ("true".equalsIgnoreCase(decryptionMode) ? this.getInputStream(is, password) : is);
        return result;
    }

    @Override
    public InputStream getInputStream(InputStream is) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(2, PasswordFactory.getInstance().create());
        return new CipherInputStream(is, cipher);
    }

    @Override
    public InputStream getInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(2, password);
        return new CipherInputStream(is, cipher);
    }

    @Override
    public InputStream getSmartInputStream(InputStream is) throws GeneralSecurityException, IOException {
        return this.getSmartInputStream(is, PasswordFactory.getInstance().create());
    }

    @Override
    public abstract InputStream getSmartInputStream(InputStream var1, char[] var2) throws GeneralSecurityException, IOException;

    @Override
    public OutputStream getOutputStream(OutputStream os) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(1, PasswordFactory.getInstance().create());
        return new CipherOutputStream(os, cipher);
    }

    @Override
    public OutputStream getOutputStream(OutputStream os, char[] password) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(1, password);
        return new CipherOutputStream(os, cipher);
    }

    protected abstract Cipher createCipher(int var1, char[] var2) throws GeneralSecurityException, IOException;
}

