/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.commons.betwixt.digester.RuleSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MappedPropertyRule
extends RuleSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$digester$MappedPropertyRule == null ? (class$org$apache$commons$betwixt$digester$MappedPropertyRule = MappedPropertyRule.class$("org.apache.commons.betwixt.digester.MappedPropertyRule")) : class$org$apache$commons$betwixt$digester$MappedPropertyRule));
    private ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$MappedPropertyRule;

    protected PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) {
        if (beanClass != null && propertyName != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Searching for property " + propertyName + " on " + beanClass));
            }
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                if (descriptors != null) {
                    int i = 0;
                    int size = descriptors.length;
                    while (i < size) {
                        PropertyDescriptor descriptor = descriptors[i];
                        if (propertyName.equals(descriptor.getName())) {
                            log.trace((Object)"Found matching method.");
                            return descriptor;
                        }
                        ++i;
                    }
                }
                if (beanClass.isInterface()) {
                    Class<?>[] superinterfaces = beanClass.getInterfaces();
                    int i = 0;
                    int size = superinterfaces.length;
                    while (i < size) {
                        PropertyDescriptor descriptor = this.getPropertyDescriptor(superinterfaces[i], propertyName);
                        if (descriptor != null) {
                            return descriptor;
                        }
                        ++i;
                    }
                }
                log.trace((Object)"No match found.");
                return null;
            }
            catch (Exception e) {
                log.warn((Object)"Caught introspection exception", (Throwable)e);
            }
        }
        return null;
    }

    protected Class getPropertyType(String propertyClassName, Class beanClass, String propertyName) {
        PropertyDescriptor descriptor;
        if (propertyClassName != null) {
            try {
                Class<?> answer = this.classLoader.loadClass(propertyClassName);
                if (answer != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Used specified type " + answer));
                    }
                    return answer;
                }
            }
            catch (Exception e) {
                log.warn((Object)"Cannot load specified type", (Throwable)e);
            }
        }
        if ((descriptor = this.getPropertyDescriptor(beanClass, propertyName)) != null) {
            return descriptor.getPropertyType();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Cannot find property type.");
            log.trace((Object)("  className=" + propertyClassName + " base=" + beanClass + " name=" + propertyName));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

