/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.expression;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapEntryAdder {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$expression$MapEntryAdder == null ? (class$org$apache$commons$betwixt$expression$MapEntryAdder = MapEntryAdder.class$("org.apache.commons.betwixt.expression.MapEntryAdder")) : class$org$apache$commons$betwixt$expression$MapEntryAdder));
    private Method adderMethod;
    private boolean keyUpdated = false;
    private Object key;
    private boolean valueUpdated = false;
    private Object value;
    static /* synthetic */ Class class$org$apache$commons$betwixt$expression$MapEntryAdder;

    public static void setLog(Log newLog) {
        log = newLog;
    }

    public MapEntryAdder(Method method) {
        Class<?>[] types = method.getParameterTypes();
        if (types == null || types.length != 2) {
            throw new IllegalArgumentException("Method used to add entries to maps must have two parameter.");
        }
        this.adderMethod = method;
    }

    public Updater getKeyUpdater() {
        return new Updater(){

            public void update(Context context, Object keyValue) {
                if (!MapEntryAdder.this.keyUpdated) {
                    MapEntryAdder.this.keyUpdated = true;
                    MapEntryAdder.this.key = keyValue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Setting entry key to " + MapEntryAdder.this.key));
                        log.trace((Object)("Current entry value is " + MapEntryAdder.this.value));
                    }
                    if (MapEntryAdder.this.valueUpdated) {
                        MapEntryAdder.this.callAdderMethod(context);
                    }
                }
            }
        };
    }

    public Updater getValueUpdater() {
        return new Updater(){

            public void update(Context context, Object valueValue) {
                if (!MapEntryAdder.this.valueUpdated) {
                    MapEntryAdder.this.valueUpdated = true;
                    MapEntryAdder.this.value = valueValue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Setting entry value to " + MapEntryAdder.this.value));
                        log.trace((Object)("Current entry key is " + MapEntryAdder.this.key));
                    }
                    if (MapEntryAdder.this.keyUpdated) {
                        MapEntryAdder.this.callAdderMethod(context);
                    }
                }
            }
        };
    }

    private void callAdderMethod(Context context) {
        log.trace((Object)"Calling adder method");
        this.keyUpdated = false;
        this.valueUpdated = false;
        Class<?>[] types = this.adderMethod.getParameterTypes();
        Class<?> keyType = types[0];
        Class<?> valueType = types[1];
        Object bean = context.getBean();
        if (bean != null) {
            if (this.key instanceof String) {
                this.key = context.getObjectStringConverter().stringToObject((String)this.key, keyType, context);
            }
            if (this.value instanceof String) {
                this.value = context.getObjectStringConverter().stringToObject((String)this.value, valueType, context);
            }
            if (this.value instanceof Collection && valueType.isArray()) {
                Collection valuesAsCollection = (Collection)this.value;
                Class<?> componentType = valueType.getComponentType();
                if (componentType != null) {
                    Object[] valuesAsArray = (Object[])Array.newInstance(componentType, valuesAsCollection.size());
                    this.value = valuesAsCollection.toArray(valuesAsArray);
                }
            }
            Object[] arguments = new Object[]{this.key, this.value};
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Calling adder method: " + this.adderMethod.getName() + " on bean: " + bean + " with key: " + this.key + " and value: " + this.value));
                }
                this.adderMethod.invoke(bean, arguments);
            }
            catch (Exception e) {
                log.warn((Object)("Cannot evaluate adder method: " + this.adderMethod.getName() + " on bean: " + bean + " of type: " + bean.getClass().getName() + " with value: " + this.value + " of type: " + valueType + " and key: " + this.key + " of type: " + keyType));
                log.debug((Object)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

