/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import ojb.broker.Identity;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.cache.ObjectCache;
import ojb.broker.cache.ObjectCacheFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.query.Query;
import ojb.broker.singlevm.PersistenceBrokerImpl;

public class RsIterator
implements Iterator {
    protected static boolean _debug = false;
    protected static ObjectCache cache = ObjectCacheFactory.getObjectCache();
    protected PersistenceBrokerImpl m_broker;
    protected ResultSet m_rs;
    protected ClassDescriptor m_mif;
    protected boolean hasCalledCheck = false;
    protected boolean hasNext = false;

    public static void setDebug(boolean b) {
        _debug = b;
    }

    public synchronized boolean hasNext() {
        try {
            block7: {
                try {
                    if (this.hasCalledCheck) break block7;
                    this.hasCalledCheck = true;
                    this.hasNext = this.m_rs.next();
                    if (this.hasNext) break block7;
                    this.releaseDbResources();
                }
                catch (Exception ex) {
                    this.hasNext = false;
                    Object var3_2 = null;
                    if (_debug) {
                        System.out.println("hasNext() -> " + this.hasNext);
                    }
                    return this.hasNext;
                }
            }
            Object var3_1 = null;
            if (_debug) {
                System.out.println("hasNext() -> " + this.hasNext);
            }
            return this.hasNext;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (_debug) {
                System.out.println("hasNext() -> " + this.hasNext);
            }
            return this.hasNext;
        }
    }

    public synchronized Object next() throws NoSuchElementException {
        try {
            if (!this.hasCalledCheck) {
                this.hasNext();
            }
            this.hasCalledCheck = false;
            if (this.hasNext) {
                Object obj = this.getObjectFromResultSet();
                if (_debug) {
                    System.out.println("next() -> " + obj);
                }
                return obj;
            }
            throw new NoSuchElementException();
        }
        catch (Exception ex) {
            if (_debug) {
                System.out.println("next() -> ERROR");
            }
            ex.printStackTrace();
            throw new NoSuchElementException();
        }
    }

    public void remove() {
        System.out.println("removing not supported by RsIterator");
    }

    public RsIterator(Query query, ClassDescriptor mif, PersistenceBrokerImpl broker) {
        if (_debug) {
            System.out.println("RsIterator(" + query + ", " + mif + ")");
        }
        this.m_rs = new JdbcAccess(broker).executeQuery(query, mif);
        this.m_broker = broker;
        this.m_mif = mif;
    }

    protected Identity getIdentityFromResultSet() throws PersistenceBrokerException {
        try {
            Class c = this.m_mif.getClassOfObject();
            Object obj = c.newInstance();
            FieldDescriptor[] pkfields = this.m_mif.getPkFields();
            int i = 0;
            while (i < pkfields.length) {
                FieldDescriptor fld = pkfields[i];
                Object colValue = JdbcAccess.getObjectFromColumn(this.m_rs, fld);
                fld.getPersistentField().set(obj, colValue);
                ++i;
            }
            return new Identity(c, this.m_mif.getKeyValues(obj));
        }
        catch (SQLException ex) {
            throw new PersistenceBrokerException(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ClassNotPersistenceCapableException("No public Constructor for " + this.m_mif.getClassOfObject() + "\n" + ex.getMessage());
        }
    }

    private Object getObjectFromResultSet() {
        try {
            Object result = this.m_mif.getRowReader().readObjectFrom(this.m_rs, this.m_mif);
            Identity oid = new Identity(result);
            Object check = cache.lookup(oid);
            if (check != null) {
                return check;
            }
            cache.cache(oid, result);
            this.m_broker.retrieveReferences(result, this.m_mif);
            this.m_broker.retrieveCollections(result, this.m_mif);
            return result;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public void releaseDbResources() {
        try {
            this.m_rs.getStatement().close();
            this.m_rs.close();
            this.m_rs = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

