/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.cache;

import java.util.Hashtable;
import ojb.broker.Identity;
import ojb.broker.cache.ObjectCache;
import ojb.broker.metadata.ClassNotPersistenceCapableException;

public class SizeLimitedCacheImpl
implements ObjectCache {
    private static final int LRU_OLD = 0;
    private static final int LRU_NEW = 1;
    private Hashtable mapKeyPos;
    private Object[] keys;
    private Object[] objects;
    private int[] status;
    private int cur;
    private int size;

    public SizeLimitedCacheImpl() {
        this(16384);
    }

    public SizeLimitedCacheImpl(int pSize) {
        this.keys = new Identity[pSize];
        this.objects = new Object[pSize];
        this.status = new int[pSize];
        this.mapKeyPos = new Hashtable(pSize);
        this.size = pSize;
    }

    public synchronized Object lookup(Identity oid) {
        Integer intvalue = (Integer)this.mapKeyPos.get(oid.toString());
        if (intvalue != null) {
            int pos = intvalue;
            this.status[pos] = 1;
            return this.objects[pos];
        }
        return null;
    }

    public void remove(Object obj) {
        this.remove(new Identity(obj));
    }

    private int walkStatus() {
        int s = this.status[this.cur];
        if (this.status[this.cur] == 1) {
            this.status[this.cur] = 0;
            ++this.cur;
            if (this.cur >= this.size) {
                this.cur = 0;
            }
            return 1;
        }
        return 0;
    }

    public void cache(Object obj) throws ClassNotPersistenceCapableException {
        this.cache(new Identity(obj), obj);
    }

    public synchronized void cache(Identity oid, Object obj) {
        String key = oid.toString();
        Integer oldPos = (Integer)this.mapKeyPos.get(key);
        if (oldPos != null) {
            int pos = oldPos;
            this.objects[pos] = obj;
            this.status[pos] = 1;
        } else {
            while (this.walkStatus() != 0) {
            }
            Integer intvalue = null;
            if (this.keys[this.cur] != null) {
                System.out.println("reorganizing cache...");
                intvalue = this.mapKeyPos.remove(this.keys[this.cur]);
            } else {
                intvalue = new Integer(this.cur);
            }
            this.keys[this.cur] = key;
            this.objects[this.cur] = obj;
            this.status[this.cur] = 1;
            this.mapKeyPos.put(key, intvalue);
            ++this.cur;
            if (this.cur >= this.size) {
                this.cur = 0;
            }
        }
    }

    public synchronized void remove(Identity oid) {
        Integer intvalue = (Integer)this.mapKeyPos.remove(oid.toString());
        if (intvalue != null) {
            int pos = intvalue;
            this.keys[pos] = null;
            this.objects[pos] = null;
            this.status[pos] = 0;
        }
    }

    public synchronized void clear() {
        int i = 0;
        while (i < this.size) {
            this.keys[i] = null;
            this.objects[i] = null;
            this.status[i] = 0;
            ++i;
        }
        this.cur = 0;
    }
}

