/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.collections;

import java.io.Serializable;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.collections.DListImpl;

public class DListEntry
implements Serializable {
    protected int id;
    protected int position;
    protected Identity oid;
    protected Object realSubject;
    protected int dlistId;
    protected byte[] serializedOID;

    public DListEntry() {
    }

    public DListEntry(int anId, int aDlistId, int pos, byte[] anOid) {
        this.id = anId;
        this.dlistId = aDlistId;
        this.position = pos;
        this.serializedOID = anOid;
        this.oid = Identity.fromByteArray(anOid);
    }

    public DListEntry(DListImpl theDlist, Object theObject) {
        this.id = this.generateNewId();
        this.dlistId = theDlist.getId();
        this.position = theDlist.size();
        Identity OID = new Identity(theObject);
        this.serializedOID = OID.serialize();
        this.oid = OID;
        this.realSubject = theObject;
    }

    protected int generateNewId() {
        PersistenceBroker broker = PersistenceBrokerFactory.createPersistenceBroker();
        try {
            return broker.getUniqueId(this.getClass(), "id");
        }
        catch (PersistenceBrokerException e) {
            return -1;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public Object getRealSubject() {
        try {
            if (this.realSubject == null) {
                this.materializeRealSubject();
            }
        }
        catch (Throwable ignored) {
            System.out.println(ignored.getMessage());
            ignored.printStackTrace();
        }
        return this.realSubject;
    }

    private void materializeRealSubject() throws PersistenceBrokerException {
        this.realSubject = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker().getObjectByIdentity(this.oid);
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    void setRealSubject(Object realSubject) {
    }

    public String toString() {
        if (this.realSubject == null) {
            return this.oid.toString();
        }
        return this.realSubject.toString();
    }
}

