/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public class CompositeConfiguration
extends AbstractConfiguration {
    private List configList = new LinkedList();
    private Configuration inMemoryConfiguration;

    public CompositeConfiguration() {
        this.clear();
    }

    public CompositeConfiguration(Configuration inMemoryConfiguration) {
        this.configList.clear();
        this.inMemoryConfiguration = inMemoryConfiguration;
        this.configList.add(inMemoryConfiguration);
    }

    public void addConfiguration(Configuration config) {
        if (!this.configList.contains(config)) {
            this.configList.add(this.configList.indexOf(this.inMemoryConfiguration), config);
            if (config instanceof AbstractConfiguration) {
                ((AbstractConfiguration)config).setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
            }
        }
    }

    public void removeConfiguration(Configuration config) {
        if (!config.equals(this.inMemoryConfiguration)) {
            this.configList.remove(config);
        }
    }

    public int getNumberOfConfigurations() {
        return this.configList.size();
    }

    public void clear() {
        this.configList.clear();
        this.inMemoryConfiguration = new BaseConfiguration();
        ((BaseConfiguration)this.inMemoryConfiguration).setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
        this.configList.add(this.inMemoryConfiguration);
    }

    protected void addPropertyDirect(String key, Object token) {
        this.inMemoryConfiguration.addProperty(key, token);
    }

    protected Object getPropertyDirect(String key) {
        Configuration firstMatchingConfiguration = null;
        Iterator i = this.configList.iterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            if (!config.containsKey(key)) continue;
            firstMatchingConfiguration = config;
            break;
        }
        if (firstMatchingConfiguration != null) {
            return firstMatchingConfiguration.getProperty(key);
        }
        return null;
    }

    public Iterator getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator i = this.configList.iterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            Iterator j = config.getKeys();
            while (j.hasNext()) {
                String key = (String)j.next();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
        }
        return keys.iterator();
    }

    public Iterator getKeys(String key) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator i = this.configList.iterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            Iterator j = config.getKeys(key);
            while (j.hasNext()) {
                String newKey = (String)j.next();
                if (keys.contains(newKey)) continue;
                keys.add(newKey);
            }
        }
        return keys.iterator();
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        Iterator i = this.configList.iterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            if (config.isEmpty()) continue;
            return false;
        }
        return isEmpty;
    }

    public Object getProperty(String key) {
        return this.getPropertyDirect(key);
    }

    public void setProperty(String key, Object value) {
        this.clearProperty(key);
        this.addProperty(key, value);
    }

    public void clearProperty(String key) {
        Iterator i = this.configList.iterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            config.clearProperty(key);
        }
    }

    public boolean containsKey(String key) {
        Iterator i = this.configList.iterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public List getList(String key, List defaultValue) {
        ArrayList list = new ArrayList();
        Iterator it = this.configList.iterator();
        while (it.hasNext() && list.isEmpty()) {
            Configuration config = (Configuration)it.next();
            if (config == this.inMemoryConfiguration || !config.containsKey(key)) continue;
            list.addAll(config.getList(key));
        }
        list.addAll(this.inMemoryConfiguration.getList(key));
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list;
    }

    public Vector getVector(String key, Vector defaultValue) {
        return new Vector(this.getList(key, defaultValue));
    }

    public String[] getStringArray(String key) {
        List list = this.getList(key);
        String[] tokens = new String[list.size()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.interpolate(String.valueOf(list.get(i)));
        }
        return tokens;
    }

    public Configuration getConfiguration(int index) {
        return (Configuration)this.configList.get(index);
    }

    public Configuration getInMemoryConfiguration() {
        return this.inMemoryConfiguration;
    }
}

