/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.DefaultValidator;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.ValidationException;

public class DateStringValidator
extends DefaultValidator {
    private static final String DEFAULT_DATE_MESSAGE = "Date could not be parsed";
    private List dateFormats = null;
    private String dateFormatMessage = null;
    private boolean flexible = false;
    private DateFormat df = null;
    private SimpleDateFormat sdf = null;

    public DateStringValidator(Map paramMap) throws IntakeException {
        this.init(paramMap);
    }

    public DateStringValidator() {
        this.dateFormats = new ArrayList(5);
    }

    public void init(Map paramMap) throws InvalidMaskException {
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("format");
        if (constraint != null) {
            this.dateFormats.add(constraint.getValue());
            this.setDateFormatMessage(constraint.getMessage());
        }
        int i = 1;
        while ((constraint = (Constraint)paramMap.get("format" + i)) != null) {
            this.dateFormats.add(constraint.getValue());
            this.setDateFormatMessage(constraint.getMessage());
            ++i;
        }
        if (StringUtils.isEmpty((String)this.dateFormatMessage)) {
            this.dateFormatMessage = DEFAULT_DATE_MESSAGE;
        }
        if ((constraint = (Constraint)paramMap.get("flexible")) != null) {
            this.flexible = Boolean.valueOf(constraint.getValue());
        }
        if (this.dateFormats.size() == 0) {
            this.df = DateFormat.getInstance();
            this.sdf = null;
            this.df.setLenient(this.flexible);
        } else {
            this.sdf = new SimpleDateFormat();
            this.df = null;
            this.sdf.setLenient(this.flexible);
        }
    }

    public void assertValidity(String testValue) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            try {
                this.parse(testValue);
            }
            catch (ParseException e) {
                this.errorMessage = this.dateFormatMessage;
                throw new ValidationException(this.dateFormatMessage);
            }
        }
    }

    public Date parse(String s) throws ParseException {
        Date date = null;
        if (s == null) {
            throw new ParseException("Input string was null", -1);
        }
        if (this.sdf != null) {
            for (int i = 1; i < this.dateFormats.size() - 1; ++i) {
                this.sdf.applyPattern((String)this.dateFormats.get(i));
                try {
                    date = this.sdf.parse(s);
                    break;
                }
                catch (ParseException e) {
                    continue;
                }
            }
            if (date == null) {
                this.sdf.applyPattern((String)this.dateFormats.get(0));
                try {
                    date = this.sdf.parse(s);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (date == null && this.df != null) {
            date = this.df.parse(s);
        }
        if (date == null) {
            throw new ParseException("Could not parse the date", 0);
        }
        return date;
    }

    public String format(Date date) {
        String s = null;
        if (date != null) {
            if (this.sdf != null) {
                this.sdf.applyPattern((String)this.dateFormats.get(0));
                s = this.sdf.format(date);
            } else {
                s = this.df.format(date);
            }
        }
        return s;
    }

    public String getDateFormatMessage() {
        return this.dateFormatMessage;
    }

    public void setDateFormatMessage(String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            this.dateFormatMessage = message;
        }
    }

    public List getDateFormats() {
        return this.dateFormats;
    }

    public void setDateFormats(List formats) {
        this.dateFormats = formats;
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public void setFlexible(boolean flexible) {
        this.flexible = flexible;
    }
}

