/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorInvocationHandler;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorService;
import org.apache.fulcrum.yaafi.framework.reflection.Clazz;
import org.apache.fulcrum.yaafi.framework.util.ReadWriteLock;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class AvalonInterceptorFactory {
    public static Object create(String serviceName, String serviceShorthand, ServiceManager serviceManager, String[] serviceInterceptorList, Object serviceDelegate, ReadWriteLock readWriteLock) throws ServiceException {
        Validate.notEmpty(serviceName, "serviceName");
        Validate.notEmpty(serviceShorthand, "serviceShorthand");
        Validate.notNull(serviceManager, "serviceManager");
        Validate.notNull(serviceInterceptorList, "serviceInterceptorList");
        Validate.notNull(serviceDelegate, "serviceDelegate");
        Validate.notNull(readWriteLock, "readWriteLock");
        Object result = null;
        Class<?> clazz = serviceDelegate.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        List interfaceList = Clazz.getAllInterfaces(clazz);
        AvalonInterceptorService[] avalonInterceptorServices = AvalonInterceptorFactory.resolve(serviceManager, serviceInterceptorList);
        AvalonInterceptorInvocationHandler invocationHandler = new AvalonInterceptorInvocationHandler(serviceName, serviceShorthand, serviceDelegate, avalonInterceptorServices, readWriteLock);
        result = Proxy.newProxyInstance(classLoader, interfaceList.toArray(new Class[interfaceList.size()]), (InvocationHandler)invocationHandler);
        return result;
    }

    private static AvalonInterceptorService[] resolve(ServiceManager serviceManager, String[] interceptorList) throws ServiceException {
        String interceptorServiceName = null;
        AvalonInterceptorService[] result = new AvalonInterceptorService[interceptorList.length];
        for (int i = 0; i < interceptorList.length; ++i) {
            interceptorServiceName = interceptorList[i];
            Object currService = serviceManager.lookup(interceptorServiceName);
            if (!(currService instanceof AvalonInterceptorService)) {
                String msg = "The following service is not an AvalonInterceptorService : " + interceptorServiceName;
                throw new ServiceException("yaafi", msg);
            }
            result[i] = (AvalonInterceptorService)currService;
        }
        return result;
    }
}

