/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.CompareCallback;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.FieldReference;
import org.apache.fulcrum.intake.validator.IntegerValidator;
import org.apache.fulcrum.intake.validator.InvalidMaskException;
import org.apache.fulcrum.intake.validator.ValidationException;

public class IntegerRangeValidator
extends IntegerValidator {
    List fieldReferences;
    CompareCallback compareCallback;

    public IntegerRangeValidator(Map paramMap) throws IntakeException {
        this();
        this.init(paramMap);
    }

    public IntegerRangeValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        super.init(paramMap);
        this.compareCallback = new CompareCallback(){

            public boolean compareValues(int compare, Object thisValue, Object refValue) throws ClassCastException {
                boolean result = true;
                Integer thisInt = (Integer)thisValue;
                Integer otherInt = (Integer)refValue;
                switch (compare) {
                    case 1: {
                        result = thisInt.compareTo(otherInt) < 0;
                        break;
                    }
                    case 3: {
                        result = thisInt.compareTo(otherInt) <= 0;
                        break;
                    }
                    case 2: {
                        result = thisInt.compareTo(otherInt) > 0;
                        break;
                    }
                    case 4: {
                        result = thisInt.compareTo(otherInt) >= 0;
                    }
                }
                return result;
            }
        };
        this.fieldReferences = new ArrayList(10);
        Iterator i = paramMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Constraint constraint = (Constraint)entry.getValue();
            int compare = FieldReference.getCompareType(key);
            if (compare == 0) continue;
            FieldReference fieldref = new FieldReference();
            fieldref.setCompare(compare);
            fieldref.setFieldName(constraint.getValue());
            fieldref.setMessage(constraint.getMessage());
            this.fieldReferences.add(fieldref);
        }
        if (this.fieldReferences.isEmpty()) {
            this.log.warn((Object)"No reference field rules have been found.");
        }
    }

    public void assertValidity(Field testField) throws ValidationException {
        super.assertValidity(testField);
        Group thisGroup = testField.getGroup();
        if (testField.isMultiValued()) {
            String[] stringValues = (String[])testField.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i], thisGroup);
            }
        } else {
            String testValue = (String)testField.getTestValue();
            this.assertValidity(testValue, thisGroup);
        }
    }

    public void assertValidity(String testValue, Group group) throws ValidationException {
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            Integer testInt = new Integer(testValue);
            try {
                FieldReference.checkReferences(this.fieldReferences, this.compareCallback, testInt, group);
            }
            catch (ValidationException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
    }
}

