/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.adapter.DB;
import org.apache.torque.adapter.DBFactory;
import org.apache.torque.dsfactory.DataSourceFactory;
import org.apache.torque.manager.AbstractBaseManager;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.MapBuilder;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.oid.IDGeneratorFactory;

public class TorqueInstance {
    private static Log log = LogFactory.getLog((Class)TorqueInstance.class);
    private static final String DEFAULT_NAME = "default";
    private String defaultDBName = null;
    private Map databases = Collections.synchronizedMap(new HashMap());
    private Map managers;
    private Configuration conf;
    private boolean isInit = false;
    private boolean defaultDsfIsReference = false;
    private Map mapBuilderCache = null;

    public TorqueInstance() {
        this.resetConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() throws TorqueException {
        log.debug((Object)"initialize()");
        if (this.isInit) {
            log.debug((Object)"Multiple initializations of Torque attempted");
            return;
        }
        if (this.conf == null || this.conf.isEmpty()) {
            throw new TorqueException("Torque cannot be initialized without a valid configuration. Please check the log files for further details.");
        }
        Configuration subConf = this.conf.subset("torque");
        if (subConf == null || subConf.isEmpty()) {
            String error = "Invalid configuration. No keys starting with torque found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        this.setConfiguration(subConf);
        this.initDefaultDbName(this.conf);
        this.initAdapters(this.conf);
        this.initDataSourceFactories(this.conf);
        this.initManagerMappings(this.conf);
        this.isInit = true;
        Map map = this.mapBuilderCache;
        synchronized (map) {
            Iterator i = this.mapBuilderCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (null != entry.getValue()) continue;
                try {
                    MapBuilder builder = (MapBuilder)Class.forName((String)entry.getKey()).newInstance();
                    if (!builder.isBuilt()) {
                        builder.doBuild();
                    }
                    entry.setValue(builder);
                }
                catch (Exception e) {
                    throw new TorqueException(e);
                }
            }
        }
    }

    private void initDefaultDbName(Configuration conf) throws TorqueException {
        this.defaultDBName = conf.getString("database.default");
        if (this.defaultDBName == null) {
            String error = "Invalid configuration: Key torque.database.default not set";
            log.error((Object)error);
            throw new TorqueException(error);
        }
    }

    private void initAdapters(Configuration conf) throws TorqueException {
        log.debug((Object)("initAdapters(" + conf + ")"));
        Configuration c = conf.subset("database");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration : No keys starting with torque.database found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.endsWith("adapter") && !key.endsWith("driver")) continue;
                String adapter = c.getString(key);
                String handle = key.substring(0, key.indexOf(46));
                DB db = DBFactory.create(adapter);
                if (db == null) {
                    String adapterClassName = c.getString(key + "." + adapter + ".className", null);
                    db = DBFactory.create(adapter, adapterClassName);
                }
                Database database = this.getOrCreateDatabase(handle);
                database.setAdapter(db);
                log.debug((Object)("Adding " + adapter + " -> " + handle + " as Adapter"));
                this.getDatabaseMap(handle);
                for (int i = 0; i < IDGeneratorFactory.ID_GENERATOR_METHODS.length; ++i) {
                    database.addIdGenerator(IDGeneratorFactory.ID_GENERATOR_METHODS[i], IDGeneratorFactory.create(db, handle));
                }
            }
        }
        catch (InstantiationException e) {
            log.error((Object)"Error creating a database adapter instance", (Throwable)e);
            throw new TorqueException(e);
        }
        catch (TorqueException e) {
            log.error((Object)"Error reading configuration seeking database adapters", (Throwable)((Object)e));
            throw new TorqueException((Throwable)((Object)e));
        }
        Database defaultDatabase = (Database)this.databases.get(Torque.getDefaultDB());
        if (defaultDatabase == null || defaultDatabase.getAdapter() == null) {
            String error = "Invalid configuration : No adapter definition found for default DB An adapter must be defined under torque.database." + Torque.getDefaultDB() + "." + "adapter";
            log.error((Object)error);
            throw new TorqueException(error);
        }
    }

    private void initDataSourceFactories(Configuration conf) throws TorqueException {
        log.debug((Object)("initDataSourceFactories(" + conf + ")"));
        Configuration c = conf.subset("dsfactory");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration: No keys starting with torque.dsfactory found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.endsWith("factory")) continue;
                String classname = c.getString(key);
                String handle = key.substring(0, key.indexOf(46));
                log.debug((Object)("handle: " + handle + " DataSourceFactory: " + classname));
                Class<?> dsfClass = Class.forName(classname);
                DataSourceFactory dsf = (DataSourceFactory)dsfClass.newInstance();
                dsf.initialize(c.subset(handle));
                Database database = this.getOrCreateDatabase(handle);
                database.setDataSourceFactory(dsf);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Runtime Error reading adapter configuration", (Throwable)e);
            throw new TorqueRuntimeException(e);
        }
        catch (Exception e) {
            log.error((Object)"Error reading adapter configuration", (Throwable)e);
            throw new TorqueException(e);
        }
        Database defaultDatabase = (Database)this.databases.get(this.defaultDBName);
        if (defaultDatabase == null || defaultDatabase.getDataSourceFactory() == null) {
            String error = "Invalid configuration : No DataSourceFactory definition for default DB found. A DataSourceFactory must be defined under the keytorque.dsfactory." + this.defaultDBName + "." + "factory";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        Database databaseInfoForKeyDefault = this.getOrCreateDatabase(DEFAULT_NAME);
        if (!this.defaultDBName.equals(DEFAULT_NAME) && databaseInfoForKeyDefault.getDataSourceFactory() == null) {
            log.debug((Object)("Adding the DatasourceFactory and DatabaseAdapter from database " + this.defaultDBName + " onto database " + DEFAULT_NAME));
            databaseInfoForKeyDefault.setDataSourceFactory(defaultDatabase.getDataSourceFactory());
            databaseInfoForKeyDefault.setAdapter(defaultDatabase.getAdapter());
            this.defaultDsfIsReference = true;
        }
    }

    public void init(String configFile) throws TorqueException {
        log.debug((Object)("init(" + configFile + ")"));
        try {
            PropertiesConfiguration configuration = new PropertiesConfiguration(configFile);
            log.debug((Object)("Config Object is " + configuration));
            this.init((Configuration)configuration);
        }
        catch (ConfigurationException e) {
            throw new TorqueException(e);
        }
    }

    public synchronized void init(Configuration conf) throws TorqueException {
        log.debug((Object)("init(" + conf + ")"));
        this.setConfiguration(conf);
        this.initialize();
    }

    protected void initManagerMappings(Configuration conf) throws TorqueException {
        int pref = "managed_class.".length();
        int suff = ".manager".length();
        Iterator it = conf.getKeys();
        while (it.hasNext()) {
            String managedClassKey;
            String key = (String)it.next();
            if (!key.startsWith("managed_class.") || !key.endsWith(".manager") || this.managers.containsKey(managedClassKey = key.substring(pref, key.length() - suff))) continue;
            String managerClass = conf.getString(key);
            log.info((Object)("Added Manager for Class: " + managedClassKey + " -> " + managerClass));
            try {
                this.initManager(managedClassKey, managerClass);
            }
            catch (TorqueException e) {
                log.error((Object)"", (Throwable)((Object)e));
                e.printStackTrace();
                throw e;
            }
        }
    }

    private synchronized void initManager(String name, String className) throws TorqueException {
        AbstractBaseManager manager = (AbstractBaseManager)this.managers.get(name);
        if (manager == null && className != null && className.length() != 0) {
            try {
                manager = (AbstractBaseManager)Class.forName(className).newInstance();
                this.managers.put(name, manager);
            }
            catch (Exception e) {
                throw new TorqueException("Could not instantiate manager associated with class: " + name, e);
            }
        }
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setConfiguration(Configuration conf) {
        log.debug((Object)("setConfiguration(" + conf + ")"));
        this.conf = conf;
    }

    public Configuration getConfiguration() {
        log.debug((Object)("getConfiguration() = " + this.conf));
        return this.conf;
    }

    public AbstractBaseManager getManager(String name) {
        AbstractBaseManager m = (AbstractBaseManager)this.managers.get(name);
        if (m == null) {
            log.error((Object)("No configured manager for key " + name + "."));
        }
        return m;
    }

    public AbstractBaseManager getManager(String name, String defaultClassName) {
        AbstractBaseManager m = (AbstractBaseManager)this.managers.get(name);
        if (m == null) {
            log.debug((Object)("Added late Manager mapping for Class: " + name + " -> " + defaultClassName));
            try {
                this.initManager(name, defaultClassName);
            }
            catch (TorqueException e) {
                log.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
            m = (AbstractBaseManager)this.managers.get(name);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() throws TorqueException {
        Iterator<Object> it;
        Map map = this.databases;
        synchronized (map) {
            it = this.databases.values().iterator();
            while (it.hasNext()) {
                Database database = (Database)it.next();
                IDBroker idBroker = database.getIDBroker();
                if (idBroker == null) continue;
                idBroker.stop();
            }
        }
        map = this.managers;
        synchronized (map) {
            it = this.managers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry mentry = (Map.Entry)it.next();
                AbstractBaseManager manager = (AbstractBaseManager)mentry.getValue();
                manager.dispose();
                it.remove();
            }
        }
        TorqueException exception = null;
        Map map2 = this.databases;
        synchronized (map2) {
            Iterator it2 = this.databases.keySet().iterator();
            while (it2.hasNext()) {
                Object databaseKey = it2.next();
                Database database = (Database)this.databases.get(databaseKey);
                if (DEFAULT_NAME.equals(databaseKey) && this.defaultDsfIsReference) {
                    database.setDataSourceFactory(null);
                    break;
                }
                try {
                    DataSourceFactory dataSourceFactory = database.getDataSourceFactory();
                    if (dataSourceFactory == null) continue;
                    dataSourceFactory.close();
                    database.setDataSourceFactory(null);
                }
                catch (TorqueException e) {
                    log.error((Object)("Error while closing the DataSourceFactory " + databaseKey), (Throwable)((Object)e));
                    if (exception != null) continue;
                    exception = e;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.resetConfiguration();
    }

    private void resetConfiguration() {
        this.mapBuilderCache = Collections.synchronizedMap(new HashMap());
        this.managers = new HashMap();
        this.isInit = false;
    }

    public DatabaseMap getDatabaseMap() throws TorqueException {
        return this.getDatabaseMap(this.getDefaultDB());
    }

    public DatabaseMap getDatabaseMap(String name) throws TorqueException {
        if (name == null) {
            throw new TorqueException("DatabaseMap name was null!");
        }
        Database database = this.getOrCreateDatabase(name);
        return database.getDatabaseMap();
    }

    public Map getMapBuilders() {
        return this.mapBuilderCache;
    }

    public void registerMapBuilder(String className) {
        this.mapBuilderCache.put(className, null);
    }

    public void registerMapBuilder(MapBuilder builder) {
        this.mapBuilderCache.put(builder.getClass().getName(), builder);
    }

    public MapBuilder getMapBuilder(String className) throws TorqueException {
        try {
            MapBuilder mb = (MapBuilder)this.mapBuilderCache.get(className);
            if (mb == null) {
                mb = (MapBuilder)Class.forName(className).newInstance();
                this.mapBuilderCache.put(className, mb);
            }
            if (mb.isBuilt()) {
                return mb;
            }
            try {
                mb.doBuild();
            }
            catch (Exception e) {
                this.mapBuilderCache.remove(className);
                throw e;
            }
            return mb;
        }
        catch (Exception e) {
            log.error((Object)("getMapBuilder failed trying to instantiate: " + className), (Throwable)e);
            throw new TorqueException(e);
        }
    }

    public Connection getConnection() throws TorqueException {
        return this.getConnection(this.getDefaultDB());
    }

    public Connection getConnection(String name) throws TorqueException {
        if (!Torque.isInit()) {
            throw new TorqueException("Torque is not initialized");
        }
        try {
            return this.getDatabase(name).getDataSourceFactory().getDataSource().getConnection();
        }
        catch (SQLException se) {
            throw new TorqueException(se);
        }
    }

    public DataSourceFactory getDataSourceFactory(String name) throws TorqueException {
        Database database = this.getDatabase(name);
        DataSourceFactory dsf = null;
        if (database != null) {
            dsf = database.getDataSourceFactory();
        }
        if (dsf == null) {
            throw new TorqueException("There was no DataSourceFactory configured for the connection " + name);
        }
        return dsf;
    }

    public Connection getConnection(String name, String username, String password) throws TorqueException {
        if (!Torque.isInit()) {
            throw new TorqueException("Torque is not initialized");
        }
        try {
            return this.getDataSourceFactory(name).getDataSource().getConnection(username, password);
        }
        catch (SQLException se) {
            throw new TorqueException(se);
        }
    }

    public DB getDB(String name) throws TorqueException {
        Database database = this.getDatabase(name);
        if (database == null) {
            return null;
        }
        return database.getAdapter();
    }

    public String getDefaultDB() {
        return this.defaultDBName;
    }

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error occured while closing connection.", (Throwable)e);
            }
        }
    }

    public void setSchema(String name, String schema) throws TorqueException {
        this.getOrCreateDatabase(name).setSchema(schema);
    }

    public String getSchema(String name) throws TorqueException {
        Database database = this.getDatabase(name);
        if (database == null) {
            return null;
        }
        return database.getSchema();
    }

    public Database getDatabase(String databaseName) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized.");
        }
        return (Database)this.databases.get(databaseName);
    }

    public Map getDatabases() throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized.");
        }
        return Collections.unmodifiableMap(this.databases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getOrCreateDatabase(String databaseName) {
        Map map = this.databases;
        synchronized (map) {
            Database result = (Database)this.databases.get(databaseName);
            if (result == null) {
                result = new Database(databaseName);
                this.databases.put(databaseName, result);
            }
            return result;
        }
    }
}

