/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security;

import java.sql.Connection;
import java.util.Iterator;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.SecurityObject;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.TurbineSecurityException;

public class TurbineRole
extends SecurityObject<Role>
implements Role {
    private static final long serialVersionUID = -1354408789347969126L;
    private PermissionSet permissionSet = null;

    public TurbineRole() {
    }

    public TurbineRole(String name) {
        super(name);
    }

    @Override
    public PermissionSet getPermissions() throws Exception {
        return this.permissionSet;
    }

    @Override
    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet;
    }

    @Override
    public Role create(String name) throws TurbineSecurityException {
        TurbineRole role = new TurbineRole(name);
        TurbineSecurity.addRole(role);
        return role;
    }

    @Override
    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveRole(this);
    }

    public void save(Connection conn) throws Exception {
        throw new Exception("not implemented");
    }

    public void save(String dbname) throws Exception {
        throw new Exception("not implemented");
    }

    @Override
    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeRole(this);
    }

    @Override
    public void rename(String name) throws TurbineSecurityException {
        TurbineSecurity.renameRole(this, name);
    }

    @Override
    public void grant(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.grant(this, permission);
    }

    @Override
    public void grant(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.iterator();
        while (permissions.hasNext()) {
            TurbineSecurity.grant(this, (Permission)permissions.next());
        }
    }

    @Override
    public void revoke(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.revoke(this, permission);
    }

    @Override
    public void revoke(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.iterator();
        while (permissions.hasNext()) {
            TurbineSecurity.revoke(this, (Permission)permissions.next());
        }
    }
}

