/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.pages;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.modules.Action;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.modules.LayoutLoader;
import org.apache.turbine.modules.Page;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;

public class DefaultPage
extends Page {
    protected Log log = LogFactory.getLog(this.getClass());
    @TurbineLoader(value=Action.class)
    protected ActionLoader actionLoader;
    @TurbineLoader(value=Screen.class)
    protected ScreenLoader screenLoader;
    @TurbineLoader(value=Layout.class)
    protected LayoutLoader layoutLoader;

    @Override
    public void doBuild(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        this.doBuildBeforeAction(pipelineData);
        if (data.hasAction()) {
            this.actionLoader.exec(pipelineData, data.getAction());
        }
        if (StringUtils.isNotEmpty((String)data.getRedirectURI())) {
            return;
        }
        this.doBuildAfterAction(pipelineData);
        String screenName = data.getScreen();
        this.log.debug((Object)("Building " + screenName));
        Screen aScreen = this.screenLoader.getAssembler(screenName);
        String layout = aScreen.getLayout(pipelineData);
        if (layout != null) {
            this.layoutLoader.exec(pipelineData, layout);
        } else {
            this.screenLoader.exec(pipelineData, screenName);
        }
        this.doPostBuild(pipelineData);
    }

    protected void doBuildBeforeAction(PipelineData pipelineData) throws Exception {
    }

    protected void doBuildAfterAction(PipelineData pipelineData) throws Exception {
    }

    protected void doPostBuild(PipelineData pipelineData) throws Exception {
    }
}

