/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.BasePeerImpl;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;
import org.apache.torque.util.Transaction;
import org.apache.turbine.services.schedule.JobEntryTorque;
import org.apache.turbine.services.schedule.JobEntryTorquePeer;
import org.apache.turbine.services.schedule.JobEntryTorqueRecordMapper;

public abstract class BaseJobEntryTorquePeerImpl
extends BasePeerImpl<JobEntryTorque> {
    private static Log log = LogFactory.getLog(BaseJobEntryTorquePeerImpl.class);
    private static final long serialVersionUID = 1450726821151L;

    public BaseJobEntryTorquePeerImpl() {
        this(new JobEntryTorqueRecordMapper(), JobEntryTorquePeer.TABLE, JobEntryTorquePeer.DATABASE_NAME);
    }

    public BaseJobEntryTorquePeerImpl(RecordMapper<JobEntryTorque> recordMapper, TableMap tableMap, String databaseName) {
        super(recordMapper, tableMap, databaseName);
    }

    public List<JobEntryTorque> doSelect(JobEntryTorque obj) throws TorqueException {
        return this.doSelect(this.buildSelectCriteria(obj));
    }

    public JobEntryTorque doSelectSingleRecord(JobEntryTorque obj) throws TorqueException {
        List<JobEntryTorque> jobEntryTorqueList = this.doSelect(obj);
        JobEntryTorque jobEntryTorque = null;
        if (jobEntryTorqueList.size() > 1) {
            throw new TooManyRowsException("Object " + obj + " matched more than one record");
        }
        if (!jobEntryTorqueList.isEmpty()) {
            jobEntryTorque = jobEntryTorqueList.get(0);
        }
        return jobEntryTorque;
    }

    public JobEntryTorque getDbObjectInstance() {
        return new JobEntryTorque();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectKey doInsert(ColumnValues columnValues) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin((String)JobEntryTorquePeer.DATABASE_NAME);
            ObjectKey result = this.doInsert(columnValues, connection);
            Transaction.commit((Connection)connection);
            connection = null;
            ObjectKey objectKey = result;
            return objectKey;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback((Connection)connection);
            }
        }
    }

    public ObjectKey doInsert(ColumnValues columnValues, Connection con) throws TorqueException {
        this.correctBooleans(columnValues);
        return super.doInsert(columnValues, con);
    }

    public void doInsert(JobEntryTorque obj) throws TorqueException {
        obj.setPrimaryKey(this.doInsert(this.buildColumnValues(obj)));
        obj.setNew(false);
        obj.setModified(false);
    }

    public void doInsert(JobEntryTorque obj, Connection con) throws TorqueException {
        ObjectKey primaryKey = this.doInsert(this.buildColumnValues(obj), con);
        if (primaryKey != null) {
            obj.setPrimaryKey(primaryKey);
        }
        obj.setNew(false);
        obj.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doUpdate(ColumnValues columnValues) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin((String)JobEntryTorquePeer.DATABASE_NAME);
            int result = this.doUpdate(columnValues, connection);
            Transaction.commit((Connection)connection);
            connection = null;
            int n = result;
            return n;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback((Connection)connection);
            }
        }
    }

    public int doUpdate(ColumnValues columnValues, Connection con) throws TorqueException {
        Criteria selectCriteria = new Criteria(JobEntryTorquePeer.DATABASE_NAME);
        this.correctBooleans(columnValues);
        selectCriteria.where((Object)JobEntryTorquePeer.JOB_ID, columnValues.remove((Object)JobEntryTorquePeer.JOB_ID).getValue());
        int rowCount = this.doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    public int doUpdate(JobEntryTorque obj) throws TorqueException {
        ColumnValues columnValues = this.buildColumnValues(obj);
        int result = this.doUpdate(columnValues);
        obj.setModified(false);
        return result;
    }

    public int doUpdate(JobEntryTorque obj, Connection con) throws TorqueException {
        ColumnValues columnValues = this.buildColumnValues(obj);
        int result = this.doUpdate(columnValues, con);
        obj.setModified(false);
        return result;
    }

    public int doDelete(JobEntryTorque obj) throws TorqueException {
        int result = this.doDelete(this.buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    public int doDelete(JobEntryTorque obj, Connection con) throws TorqueException {
        int result = this.doDelete(this.buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    public int doDelete(Collection<JobEntryTorque> objects) throws TorqueException {
        int result = this.doDelete(this.buildPkCriteria(objects));
        for (JobEntryTorque object : objects) {
            object.setDeleted(true);
        }
        return result;
    }

    public int doDelete(Collection<JobEntryTorque> objects, Connection con) throws TorqueException {
        int result = this.doDelete(this.buildPkCriteria(objects), con);
        for (JobEntryTorque object : objects) {
            object.setDeleted(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doDelete(ObjectKey pk) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin((String)JobEntryTorquePeer.DATABASE_NAME);
            int deletedRows = this.doDelete(pk, connection);
            Transaction.commit((Connection)connection);
            connection = null;
            int n = deletedRows;
            return n;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback((Connection)connection);
            }
        }
    }

    public int doDelete(ObjectKey pk, Connection con) throws TorqueException {
        return this.doDelete(this.buildCriteria(pk), con);
    }

    public Criteria buildCriteria(ObjectKey pk) {
        Criteria criteria = new Criteria();
        criteria.and((Object)JobEntryTorquePeer.JOB_ID, (Object)pk);
        return criteria;
    }

    public Criteria buildCriteria(Collection<ObjectKey> pks) {
        Criteria criteria = new Criteria();
        criteria.andIn((Object)JobEntryTorquePeer.JOB_ID, pks);
        return criteria;
    }

    public Criteria buildPkCriteria(Collection<JobEntryTorque> objects) {
        ArrayList<ObjectKey> pks = new ArrayList<ObjectKey>(objects.size());
        for (JobEntryTorque object : objects) {
            ObjectKey pk = object.getPrimaryKey();
            if (pk == null) continue;
            pks.add(pk);
        }
        return this.buildCriteria(pks);
    }

    public Criteria buildCriteria(JobEntryTorque obj) {
        Criteria criteria = new Criteria(JobEntryTorquePeer.DATABASE_NAME);
        if (!obj.isNew()) {
            criteria.and((Object)JobEntryTorquePeer.JOB_ID, (Object)obj.getJobId());
        }
        criteria.and((Object)JobEntryTorquePeer.SECOND, (Object)obj.getSecond());
        criteria.and((Object)JobEntryTorquePeer.MINUTE, (Object)obj.getMinute());
        criteria.and((Object)JobEntryTorquePeer.HOUR, (Object)obj.getHour());
        criteria.and((Object)JobEntryTorquePeer.WEEK_DAY, (Object)obj.getWeekDay());
        criteria.and((Object)JobEntryTorquePeer.DAY_OF_MONTH, (Object)obj.getDayOfMonth());
        criteria.and((Object)JobEntryTorquePeer.TASK, (Object)obj.getTask());
        criteria.and((Object)JobEntryTorquePeer.EMAIL, (Object)obj.getEmail());
        criteria.and((Object)JobEntryTorquePeer.PROPERTY, (Object)obj.getProperty());
        return criteria;
    }

    public Criteria buildSelectCriteria(JobEntryTorque obj) {
        Criteria criteria = new Criteria(JobEntryTorquePeer.DATABASE_NAME);
        if (!obj.isNew()) {
            criteria.and((Object)JobEntryTorquePeer.JOB_ID, (Object)obj.getJobId());
        }
        criteria.and((Object)JobEntryTorquePeer.SECOND, (Object)obj.getSecond());
        criteria.and((Object)JobEntryTorquePeer.MINUTE, (Object)obj.getMinute());
        criteria.and((Object)JobEntryTorquePeer.HOUR, (Object)obj.getHour());
        criteria.and((Object)JobEntryTorquePeer.WEEK_DAY, (Object)obj.getWeekDay());
        criteria.and((Object)JobEntryTorquePeer.DAY_OF_MONTH, (Object)obj.getDayOfMonth());
        criteria.and((Object)JobEntryTorquePeer.TASK, (Object)obj.getTask());
        criteria.and((Object)JobEntryTorquePeer.EMAIL, (Object)obj.getEmail());
        return criteria;
    }

    public ColumnValues buildColumnValues(JobEntryTorque jobEntryTorque) throws TorqueException {
        ColumnValues columnValues = new ColumnValues();
        if (!jobEntryTorque.isNew() || jobEntryTorque.getJobId() != 0) {
            columnValues.put((Column)JobEntryTorquePeer.JOB_ID, new JdbcTypedValue((Object)jobEntryTorque.getJobId(), 4));
        }
        columnValues.put((Column)JobEntryTorquePeer.SECOND, new JdbcTypedValue((Object)jobEntryTorque.getSecond(), 4));
        columnValues.put((Column)JobEntryTorquePeer.MINUTE, new JdbcTypedValue((Object)jobEntryTorque.getMinute(), 4));
        columnValues.put((Column)JobEntryTorquePeer.HOUR, new JdbcTypedValue((Object)jobEntryTorque.getHour(), 4));
        columnValues.put((Column)JobEntryTorquePeer.WEEK_DAY, new JdbcTypedValue((Object)jobEntryTorque.getWeekDay(), 4));
        columnValues.put((Column)JobEntryTorquePeer.DAY_OF_MONTH, new JdbcTypedValue((Object)jobEntryTorque.getDayOfMonth(), 4));
        columnValues.put((Column)JobEntryTorquePeer.TASK, new JdbcTypedValue((Object)jobEntryTorque.getTask(), 12));
        columnValues.put((Column)JobEntryTorquePeer.EMAIL, new JdbcTypedValue((Object)jobEntryTorque.getEmail(), 12));
        columnValues.put((Column)JobEntryTorquePeer.PROPERTY, new JdbcTypedValue((Object)jobEntryTorque.getProperty(), -3));
        return columnValues;
    }

    public JobEntryTorque retrieveByPK(int pk) throws TorqueException, NoRowsException, TooManyRowsException {
        return this.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)pk));
    }

    public JobEntryTorque retrieveByPK(int pk, Connection con) throws TorqueException, NoRowsException, TooManyRowsException {
        return this.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)pk), con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobEntryTorque retrieveByPK(ObjectKey pk) throws TorqueException, NoRowsException, TooManyRowsException {
        Connection connection = null;
        try {
            connection = Transaction.begin((String)JobEntryTorquePeer.DATABASE_NAME);
            JobEntryTorque result = this.retrieveByPK(pk, connection);
            Transaction.commit((Connection)connection);
            connection = null;
            JobEntryTorque jobEntryTorque = result;
            return jobEntryTorque;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback((Connection)connection);
            }
        }
    }

    public JobEntryTorque retrieveByPK(ObjectKey pk, Connection con) throws TorqueException, NoRowsException, TooManyRowsException {
        Criteria criteria = this.buildCriteria(pk);
        List v = this.doSelect(criteria, con);
        if (v.size() == 0) {
            throw new NoRowsException("Failed to select a row.");
        }
        if (v.size() > 1) {
            throw new TooManyRowsException("Failed to select only one row.");
        }
        return (JobEntryTorque)v.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobEntryTorque> retrieveByPKs(Collection<ObjectKey> pks) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin((String)JobEntryTorquePeer.DATABASE_NAME);
            List<JobEntryTorque> result = this.retrieveByPKs(pks, connection);
            Transaction.commit((Connection)connection);
            connection = null;
            List<JobEntryTorque> list = result;
            return list;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback((Connection)connection);
            }
        }
    }

    public List<JobEntryTorque> retrieveByPKs(Collection<ObjectKey> pks, Connection dbcon) throws TorqueException {
        if (pks == null || pks.size() == 0) {
            return new ArrayList<JobEntryTorque>();
        }
        Criteria criteria = this.buildCriteria(pks);
        List result = this.doSelect(criteria, dbcon);
        return result;
    }
}

