/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.template.mapper.BaseMapper;
import org.apache.turbine.services.template.mapper.Mapper;

public class ClassMapper
extends BaseMapper
implements Mapper {
    private Loader<? extends Assembler> loader = null;
    private static Log log = LogFactory.getLog(ClassMapper.class);

    public Loader<? extends Assembler> getLoader() {
        return this.loader;
    }

    public void setLoader(Loader<? extends Assembler> loader) {
        this.loader = loader;
        log.debug((Object)("Loader is " + this.loader));
    }

    @Override
    public String doMapping(String template) {
        log.debug((Object)("doMapping(" + template + ")"));
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(StringUtils.split((String)template, (String)String.valueOf(','))));
        int componentSize = components.size() - 1;
        String className = (String)components.get(componentSize);
        components.remove(componentSize--);
        log.debug((Object)("className is " + className));
        int dotIndex = className.lastIndexOf(46);
        className = dotIndex < 0 ? className : className.substring(0, dotIndex);
        boolean firstRun = !className.equals("Default");
        while (true) {
            String pkg = StringUtils.join(components.iterator(), (String)String.valueOf(this.separator));
            StringBuilder testName = new StringBuilder();
            log.debug((Object)("classPackage is now: " + pkg));
            if (!components.isEmpty()) {
                testName.append(pkg);
                testName.append(this.separator);
            }
            testName.append(firstRun ? className : "Default");
            log.debug((Object)("Looking for " + testName));
            try {
                this.loader.getAssembler(testName.toString());
                log.debug((Object)("Found it, returning " + testName));
                return testName.toString();
            }
            catch (Exception e) {
                if (firstRun) {
                    firstRun = false;
                    continue;
                }
                if (!components.isEmpty()) {
                    components.remove(componentSize--);
                    continue;
                }
                log.debug((Object)"Returning default");
                return this.getDefaultName(template);
            }
            break;
        }
    }
}

