/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.AbstractAdapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;

public class MssqlAdapter
extends AbstractAdapter {
    private static final long serialVersionUID = -2924485528975497044L;
    private static final Log log = LogFactory.getLog(MssqlAdapter.class);

    protected MssqlAdapter() {
    }

    public String toUpperCase(String in) {
        return new StringBuffer("UPPER(").append(in).append(")").toString();
    }

    public String ignoreCase(String in) {
        return new StringBuffer("UPPER(").append(in).append(")").toString();
    }

    public IDMethod getIDMethodType() {
        return IDMethod.AUTO_INCREMENT;
    }

    public String getIDMethodSQL(Object unused) {
        return "select @@identity";
    }

    public String getUpdateLockClause() {
        return "WITH (UPDLOCK)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.execute("SELECT * FROM " + table + " WITH (TABLOCKX)");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Could not close lock statement", (Throwable)e);
                }
            }
        }
    }

    public void unlockTable(Connection con, String table) throws SQLException {
    }

    public boolean supportsNativeLimit() {
        return true;
    }

    public void generateLimits(Query query, long offset, int limit) throws TorqueException {
        if (limit < 0 && offset >= 0L) {
            return;
        }
        if ((long)limit + offset > 0L) {
            query.setRowcount(String.valueOf((long)limit + offset));
        } else if ((long)limit + offset == 0L) {
            query.getWhereClause().add("1=0");
        }
    }

    public boolean escapeText() {
        return false;
    }

    public boolean useEscapeClauseForLike() {
        return true;
    }
}

