/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.adapter.AbstractAdapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;
import org.apache.torque.util.UniqueList;

public class OracleAdapter
extends AbstractAdapter {
    private static final long serialVersionUID = 8966976210230241194L;
    private static final Log log = LogFactory.getLog(OracleAdapter.class);

    protected OracleAdapter() {
    }

    public String toUpperCase(String in) {
        return new StringBuffer("UPPER(").append(in).append(")").toString();
    }

    public String ignoreCase(String in) {
        return new StringBuffer("UPPER(").append(in).append(")").toString();
    }

    public IDMethod getIDMethodType() {
        return IDMethod.SEQUENCE;
    }

    public String getIDMethodSQL(Object sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.execute("SELECT * FROM " + table + " FOR UPDATE");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Colud not close lock statement", (Throwable)e);
                }
            }
        }
    }

    public void unlockTable(Connection con, String table) throws SQLException {
        con.commit();
    }

    public boolean supportsNativeLimit() {
        return true;
    }

    public boolean supportsNativeOffset() {
        return true;
    }

    public void generateLimits(Query query, long offset, int limit) {
        String selectColumn;
        StringBuffer preLimit = new StringBuffer().append("SELECT B.* FROM ( ").append("SELECT A.*, rownum AS TORQUE$ROWNUM FROM ( ");
        StringBuffer postLimit = new StringBuffer().append(" ) A ").append(" ) B WHERE ");
        if (offset > 0L) {
            postLimit.append(" B.TORQUE$ROWNUM > ").append(offset);
            if (limit >= 0) {
                postLimit.append(" AND B.TORQUE$ROWNUM <= ").append(offset + (long)limit);
            }
        } else {
            postLimit.append(" B.TORQUE$ROWNUM <= ").append(limit);
        }
        query.setPreLimit(preLimit.toString());
        query.setPostLimit(postLimit.toString());
        query.setLimit(null);
        UniqueList<String> selectColumns = query.getSelectClause();
        int replacementSuffix = 0;
        HashSet<String> columnNames = new HashSet<String>();
        ListIterator<String> columnIt = selectColumns.listIterator();
        while (columnIt.hasNext()) {
            int spacePos;
            selectColumn = (String)columnIt.next();
            if (selectColumn.indexOf(40) != -1 || selectColumn.indexOf(41) != -1 || (spacePos = selectColumn.lastIndexOf(32)) == -1) continue;
            String aliasName = selectColumn.substring(spacePos + 1);
            columnNames.add(aliasName);
        }
        columnIt = selectColumns.listIterator();
        while (columnIt.hasNext()) {
            int spacePos;
            selectColumn = (String)columnIt.next();
            if (selectColumn.indexOf(40) != -1 || selectColumn.indexOf(41) != -1 || (spacePos = selectColumn.lastIndexOf(32)) != -1) continue;
            int dotPos = selectColumn.lastIndexOf(46);
            String column = dotPos != -1 ? selectColumn.substring(dotPos + 1) : selectColumn;
            if (columnNames.contains(column)) {
                String aliasName;
                do {
                    aliasName = "a" + replacementSuffix;
                    ++replacementSuffix;
                } while (columnNames.contains(aliasName));
                selectColumn = selectColumn + " " + aliasName;
                columnIt.set(selectColumn);
                columnNames.add(aliasName);
                continue;
            }
            columnNames.add(column);
        }
    }

    public boolean escapeText() {
        return false;
    }

    public boolean useEscapeClauseForLike() {
        return true;
    }
}

