/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.stax.FOMDiv;
import org.apache.abdera.parser.stax.FOMElement;
import org.apache.abdera.util.Constants;
import org.apache.axiom.fom.AbderaDiv;
import org.apache.axiom.fom.AbderaElementMixin;
import org.apache.axiom.fom.AbderaText;
import org.apache.axiom.fom.IRIUtil;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMText
extends FOMElement
implements AbderaText {
    protected Text.Type type = Text.Type.TEXT;

    public final Text.Type getTextType() {
        return this.type;
    }

    public Text setTextType(Text.Type type) {
        this.type = type;
        if (Text.Type.TEXT.equals((Object)type)) {
            this.setAttributeValue(Constants.TYPE, "text");
        } else if (Text.Type.HTML.equals((Object)type)) {
            this.setAttributeValue(Constants.TYPE, "html");
        } else if (Text.Type.XHTML.equals((Object)type)) {
            this.setAttributeValue(Constants.TYPE, "xhtml");
        } else {
            this.removeAttribute(Constants.TYPE);
        }
        return this;
    }

    public Div getValueElement() {
        return (Div)this._getFirstChildWithName(Constants.DIV);
    }

    public Text setValueElement(Div value) {
        if (value != null) {
            if (this._getFirstChildWithName(Constants.DIV) != null) {
                this._getFirstChildWithName(Constants.DIV).discard();
            }
            this.setTextType(Text.Type.XHTML);
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$removeChildren(this);
            this._addChild((AbderaDiv)value);
        } else {
            AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
        }
        return this;
    }

    public String getValue() {
        String val = null;
        if (Text.Type.TEXT.equals((Object)this.type)) {
            val = this.getText();
        } else if (Text.Type.HTML.equals((Object)this.type)) {
            val = this.getText();
        } else if (Text.Type.XHTML.equals((Object)this.type)) {
            FOMDiv div = (FOMDiv)this._getFirstChildWithName(Constants.DIV);
            val = div != null ? div.getInternalValue() : null;
        }
        return val;
    }

    public <T extends Element> T setText(Text.Type type, String value) {
        this.setTextType(type);
        if (value != null) {
            OMNode child = AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$getFirstOMChild(this);
            while (child != null) {
                if (child.getType() == 4) {
                    child.detach();
                }
                child = child.getNextOMSibling();
            }
            this.getOMFactory().createOMText((OMContainer)this, value);
        } else {
            AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
        }
        return (T)this;
    }

    public Text setValue(String value) {
        if (value != null) {
            if (Text.Type.TEXT.equals((Object)this.type)) {
                this.setText(this.type, value);
            } else if (Text.Type.HTML.equals((Object)this.type)) {
                this.setText(this.type, value);
            } else if (Text.Type.XHTML.equals((Object)this.type)) {
                IRI baseUri = null;
                value = "<div xmlns=\"http://www.w3.org/1999/xhtml\">" + value + "</div>";
                Element element = null;
                try {
                    baseUri = this.getResolvedBaseUri();
                    element = this._parse(value, baseUri);
                }
                catch (Exception exception) {}
                if (element != null && element instanceof Div) {
                    this.setValueElement((Div)element);
                }
            }
        } else {
            AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
        }
        return this;
    }

    public String getWrappedValue() {
        if (Text.Type.XHTML.equals((Object)this.type)) {
            return this._getFirstChildWithName(Constants.DIV).toString();
        }
        return this.getValue();
    }

    public Text setWrappedValue(String wrappedValue) {
        if (Text.Type.XHTML.equals((Object)this.type)) {
            IRI baseUri = null;
            Element element = null;
            try {
                baseUri = this.getResolvedBaseUri();
                element = this._parse(wrappedValue, baseUri);
            }
            catch (Exception exception) {}
            if (element != null && element instanceof Div) {
                this.setValueElement((Div)element);
            }
        } else {
            this.setValue(wrappedValue);
        }
        return this;
    }

    @Override
    public IRI getBaseUri() {
        Div el;
        if (Text.Type.XHTML.equals((Object)this.type) && (el = this.getValueElement()) != null && el.getAttributeValue(Constants.BASE) != null) {
            if (this.getAttributeValue(Constants.BASE) != null) {
                return super.getBaseUri().resolve(el.getAttributeValue(Constants.BASE));
            }
            return IRIUtil.getUriValue(el.getAttributeValue(Constants.BASE));
        }
        return super.getBaseUri();
    }

    @Override
    public IRI getResolvedBaseUri() {
        Div el;
        if (Text.Type.XHTML.equals((Object)this.type) && (el = this.getValueElement()) != null && el.getAttributeValue(Constants.BASE) != null) {
            return super.getResolvedBaseUri().resolve(el.getAttributeValue(Constants.BASE));
        }
        return super.getResolvedBaseUri();
    }

    @Override
    public String getLanguage() {
        Div el;
        if (Text.Type.XHTML.equals((Object)this.type) && (el = this.getValueElement()) != null && el.getAttributeValue(Constants.LANG) != null) {
            return el.getAttributeValue(Constants.LANG);
        }
        return super.getLanguage();
    }

    @Override
    public Object clone() {
        FOMText text = (FOMText)super.clone();
        text.type = this.type;
        return text;
    }
}

