/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.mime.ContentTransferEncoding;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.Header;
import org.apache.axiom.mime.MediaType;
import org.apache.axiom.mime.MultipartBodyWriter;
import org.apache.axiom.mime.PartBlob;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.format.xop.CombinedContentTransferEncodingPolicy;
import org.apache.axiom.om.format.xop.ContentTransferEncodingPolicy;
import org.apache.axiom.om.format.xop.ContentTypeProvider;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.util.io.IOUtils;

public class OMMultipartWriter {
    private final OMOutputFormat format;
    private final MultipartBodyWriter writer;
    private final ContentTransferEncodingPolicy contentTransferEncodingPolicy;
    private final ContentType rootPartContentType;

    public OMMultipartWriter(OutputStream out, OMOutputFormat format) {
        this.format = format;
        this.writer = new MultipartBodyWriter(out, format.getMimeBoundary());
        ContentTransferEncodingPolicy contentTransferEncodingPolicy = format.getContentTransferEncodingPolicy();
        if (format != null && Boolean.TRUE.equals(format.getProperty("org.apache.axiom.om.OMFormat.use.cteBase64.forNonTextualAttachments"))) {
            contentTransferEncodingPolicy = contentTransferEncodingPolicy == null ? ContentTransferEncodingPolicy.USE_BASE64_FOR_NON_TEXTUAL_PARTS : new CombinedContentTransferEncodingPolicy(contentTransferEncodingPolicy, ContentTransferEncodingPolicy.USE_BASE64_FOR_NON_TEXTUAL_PARTS);
        }
        this.contentTransferEncodingPolicy = contentTransferEncodingPolicy;
        MediaType soapContentType = format.isSOAP11() ? SOAPVersion.SOAP11.getMediaType() : SOAPVersion.SOAP12.getMediaType();
        this.rootPartContentType = format.isOptimized() ? ContentType.builder().setMediaType(MediaType.APPLICATION_XOP_XML).setParameter("charset", format.getCharSetEncoding()).setParameter("type", soapContentType.toString()).build() : ContentType.builder().setMediaType(soapContentType).setParameter("charset", format.getCharSetEncoding()).build();
    }

    private ContentType getContentType(Blob blob) {
        ContentTypeProvider contentTypeProvider = this.format.getContentTypeProvider();
        return contentTypeProvider == null ? null : contentTypeProvider.getContentType(blob);
    }

    private ContentTransferEncoding getContentTransferEncoding(Blob blob, ContentType contentType) {
        ContentTransferEncoding cte = null;
        if (this.contentTransferEncodingPolicy != null) {
            cte = this.contentTransferEncodingPolicy.getContentTransferEncoding(blob, contentType);
        }
        return cte == null ? ContentTransferEncoding.BINARY : cte;
    }

    public ContentType getRootPartContentType() {
        return this.rootPartContentType;
    }

    public OutputStream writeRootPart() throws IOException {
        return this.writer.writePart(this.rootPartContentType, ContentTransferEncoding.BINARY, this.format.getRootContentId(), null);
    }

    public OutputStream writePart(ContentType contentType, String contentID) throws IOException {
        return this.writer.writePart(contentType, this.getContentTransferEncoding(null, contentType), contentID, null);
    }

    public OutputStream writePart(ContentType contentType, String contentID, List<Header> extraHeaders) throws IOException {
        return this.writer.writePart(contentType, this.getContentTransferEncoding(null, contentType), contentID, extraHeaders);
    }

    public void writePart(Blob blob, String contentID, List<Header> extraHeaders) throws IOException {
        ContentType contentType = this.getContentType(blob);
        this.writer.writePart(blob, contentType, this.getContentTransferEncoding(blob, contentType), contentID, extraHeaders);
    }

    public void writePart(Blob blob, String contentID) throws IOException {
        this.writePart(blob, contentID, null);
    }

    public void writePart(PartBlob blob, String contentID, boolean preserve) throws IOException {
        ContentType contentType = this.getContentType(blob);
        OutputStream part = this.writer.writePart(contentType, this.getContentTransferEncoding(blob, contentType), contentID, null);
        IOUtils.copy(blob.getPart().getInputStream(preserve), part, -1L);
        part.close();
    }

    public void complete() throws IOException {
        this.writer.complete();
    }
}

